using System;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.DB.ExtensibleStorage;
using Autodesk.Revit.UI;

namespace TestLib
{
    [Transaction(TransactionMode.Manual)]
    public class StoreCmd : IExternalCommand
    {
        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            Document document = commandData.Application.ActiveUIDocument.Document;

            if (Application.ReadDataStorageProperties(document) == null)
            {
                TaskDialog.Show("TestLib", "No data was present in document yet. Storing data.");
            }
            else
            {
                TaskDialog.Show("TestLib", "Overwriting data in document with new data.");
            }

            using (Transaction transaction = new Transaction(document, "Storing Data"))
            {
                transaction.Start();
                try
                {
                    Application.WriteDataStorageProperties(document, new DataStorageProperties
                    {
                        Scale = new XYZ(1, 1, 1),
                        Size = new XYZ(10, 10, 10),
                        ExportDate = DateTime.Now.ToString("u"),
                        ExportPath = string.IsNullOrEmpty(document.PathName) ? "Non-saved file" : document.PathName
                    });
                    transaction.Commit();
                }
                catch (Exception e)
                {
                    TaskDialog.Show("TestLib Exception", e.ToString());
                    transaction.RollBack();
                }

            }

            return Result.Succeeded;
        }
    }
}