Revit 2019: Failure to store any data
===

## Prerequisites

* Revit 2019 to be present at C:\Program Files\Autodesk\Revit 2019\
    * Refers to `RevitAPI.dll` and `RevitAPIUI.dll` in this same subfolder
    * File paths have to be modified if this changes in any way 
* Opening the solution provides two projects with the same source code
    * .NET Core SDK 3.0 for building `netcore3.0` project, or .NET Framework 4.7 for `dotnet47`.
* Source code is in shared project _Source_.
    
## Running the add-in

1. When running the configurations, the files `TestLib.addin` and `TestLib.dll` are copied to `%APPDATA%\Autodesk\Revit\Addins\2019\`.
2. It will register an external application (Application.cs).
3. The commands are present under _Add-ins / TestLib_ as 'Read Data' and 'Store Data'.

## Issue at hand

Upon storing any (fairly custom data) in the project, Revit will no longer be able to open the file properly
without having to Audit the file to remove any corrupted data from the document.

1. Open any file
2. Select 'Read Data'. Note the absence of any data (obviously).
3. Select 'Write Data'. The add-in reports that it hasn't found any data in the document, and will proceed
to enter some.
4. In this session, select 'Read Data' again. Note the availability of the data previously stored.
5. **Save and close the file.**
6. Re-open the file using the quick launch box. Revit will suffer from an irreparable error and prompts to 
upload a bug report.
