using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;

namespace TestLib
{
    [Transaction(TransactionMode.Manual)]
    public class ReadCmd : IExternalCommand
    {
        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            DataStorageProperties properties =
                Application.ReadDataStorageProperties(commandData.Application.ActiveUIDocument.Document);
            if (properties == null)
            {
                TaskDialog.Show("TestLib", "No data has been stored prior to this point");
                return Result.Succeeded;
            }

            TaskDialog.Show("TestLib", $"Found: {properties}");

            return Result.Succeeded;
        }
    }
}