﻿using System;
using System.IO;

namespace guidize
{
  class JtOptions
  {
    const string ext = ".addin";

    public bool Backup { get; set; }
    public bool Overwrite { get; set; }
    public bool Verbose { get; set; }
    public string Filename { get; set; }
    public int Errorcode { get; set; }

    public string FilenameStem
    {
      get{ return Path.GetFileName( Filename ); }
    }

    void HelpMessage( int errorcode )
    {
      Errorcode = errorcode;

      Console.Error.WriteLine( 
        "guidize 2.0 -- populate Revit add-in manifest file AddInId and ClientId tags\n"
        + "Copyright (C) 2010 by Jeremy Tammik, Autodesk Inc. All rights reserved.\n"
        + "\nusage: guidize [options] manifest_file\n"
        + "  -? or -h  help\n"
        + "  -b        backup previous version of the manifest file\n"
        + "  -o        overwrite existing AddInId and ClientId entries\n"
        + "  -v        verbose" );
    }

    public JtOptions( string[] args )
    {
      Backup = false;
      Overwrite = false;
      Filename = null;
      Errorcode = 0;

      foreach( string a in args )
      {
        if( '-' == a[0] )
        {
          if( 0 < a.IndexOf( '?' ) || 0 < a.IndexOf( 'h' ) )
          {
            HelpMessage( 1 );
            return;
          }
          Backup = ( 0 < a.IndexOf( 'b' ) );
          Overwrite = ( 0 < a.IndexOf( 'o' ) );
          Verbose = ( 0 < a.IndexOf( 'v' ) );
        }
        else if( null == Filename )
        {
          Filename = a;
          if( !File.Exists( Filename ) )
          {
            if( File.Exists( Filename + ext ) )
            {
              Filename = Filename + ext;
            }
          }
          if( !File.Exists( Filename ) )
          {
            Console.Error.WriteLine( string.Format( "unable to open input file '{0}'", Filename ) );
            HelpMessage( 2 );
            return;
          }
        }
      }
      if( null == Filename || !File.Exists( Filename ) )
      {
        HelpMessage( 3 );
        return;
      }
      Filename = Path.GetFullPath( Filename );
    }
  }
}
