﻿using System;
using System.IO;
using System.Xml;

namespace guidize
{
  class Program
  {
    const string _name = "Guidize";
    const string _bak = ".bak";
    const string _tag1 = "AddInId";
    const string _tag2 = "ClientId";
    static char[] _parenthesis = new char[] { '{', '}' };

    static bool GuidizeNode( XmlNode node, JtOptions o )
    {
      bool rc = false;

      string oldText = node.InnerText;

      if( 0 == oldText.Length || o.Overwrite )
      {
        Guid g = Guid.NewGuid();
        string newText = g.ToString().Trim( _parenthesis ).ToLower();
        node.InnerText = newText;

        if( o.Verbose )
        {
          Console.WriteLine( string.Format(
            "{0} --> {1}", oldText, newText ) );
        }
        rc = true;
      }
      return rc;
    }

    static int Guidize( JtOptions o )
    {
      try
      {
        bool modified = false;
        int n = 0;

        if( o.Verbose )
        {
          Console.WriteLine( string.Format( 
            "\n{0} processing '{1}'",
            _name, o.Filename ) );
        }

        string inputPath = o.Filename;
        
        if( o.Backup )
        {
          inputPath += _bak;
          File.Move( o.Filename, inputPath );
        }
        
        XmlDocument doc = new XmlDocument();

        doc.Load( inputPath );
        
        XmlNodeList nodes1 = doc.GetElementsByTagName( _tag1 );
        XmlNodeList nodes2 = doc.GetElementsByTagName( _tag2 );

        foreach( XmlNode node in nodes1 )
        {
          if( GuidizeNode( node, o ) )
          {
            modified = true;
            ++n;
          }
        }
        foreach( XmlNode node in nodes2 )
        {
          if( GuidizeNode( node, o ) )
          {
            modified = true;
            ++n;
          }
        }
        if( o.Verbose )
        {
          Console.WriteLine( string.Format( 
            "Guidize {0}: {1} tag{2} populated.",
            o.FilenameStem, n, ( 1 == n ? "" : "s" ) ) );
        }
        if( modified )
        {
          doc.Save( o.Filename );
        }
        else if( o.Backup )
        {
          File.Move( inputPath, o.Filename ); // restore orginal filename if nothing changed
        }
      }
      catch( Exception ex )
      {
        Console.Error.WriteLine( "Guidize exception: " + ex.Message );
      }
      return 0;
    }


    static int Main( string[] args )
    {
      JtOptions options = new JtOptions( args );

      return 0 == options.Errorcode
        ? Guidize( options )
        : options.Errorcode;
    }
  }
}
