﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Autodesk.Revit.DB;
using System.Diagnostics;

namespace TempDemoSample
{

    class Utils
    {

        public static BoundingBoxXYZ BoundingBoxInModelCoordinate(BoundingBoxXYZ bbox)
        {
            if (bbox == null)
                return null;

            double[] xVals = new double[] { bbox.Min.X, bbox.Max.X };
            double[] yVals = new double[] { bbox.Min.Y, bbox.Max.Y };
            double[] zVals = new double[] { bbox.Min.Z, bbox.Max.Z };

            XYZ toTest;

            double minX, minY, minZ, maxX, maxY, maxZ;
            minX = minY = minZ = double.MaxValue;
            maxX = maxY = maxZ = double.MinValue;

            // Get the max and min coordinate from the 8 vertices
            for (int iX = 0; iX < 2; iX++)
            {
                for (int iY = 0; iY < 2; iY++)
                {
                    for (int iZ = 0; iZ < 2; iZ++)
                    {
                        toTest = bbox.Transform.OfPoint(new XYZ(xVals[iX], yVals[iY], zVals[iZ]));
                        minX = Math.Min(minX, toTest.X);
                        minY = Math.Min(minY, toTest.Y);
                        minZ = Math.Min(minZ, toTest.Z);

                        maxX = Math.Max(maxX, toTest.X);
                        maxY = Math.Max(maxY, toTest.Y);
                        maxZ = Math.Max(maxZ, toTest.Z);
                    }
                }
            }

            BoundingBoxXYZ returnBox = new BoundingBoxXYZ();
            returnBox.Max = new XYZ(maxX, maxY, maxZ);
            returnBox.Min = new XYZ(minX, minY, minZ);

            return returnBox;
        }

        private const double FEET_TO_METERS = 0.3048;

        public static double FeetToMeter(double feet)
        {
            return feet * FEET_TO_METERS;
        }

        public static double MeterToFeet(double meter)
        {
            return meter / FEET_TO_METERS;
        }


        #region mathutils

        public static double zero = 0;

        public static double TolPointOnPlane
        {
            get
            {
                return _eps;
            }
        }

        public static double MinLineLength
        {
            get
            {
                return _eps;
            }
        }

        public static bool IsParallel(XYZ p, XYZ q)
        {
            return p.CrossProduct(q).IsZeroLength();
        }


        public static double GetRadianFromVector(XYZ point)
        {
            return Math.Atan2(point.Y, point.X);
        }

        public static double ConvertXyzToRadian(XYZ point)
        {
            return Math.Atan2((double)point.Y, (double)point.X); ;
        }

        public static double DegreeToRadian(double angle)
        {
            return Math.PI * angle / 180.0;
        }

        public static double RadianToDegree(double rad)
        {
            return rad * (180.0 / Math.PI);
        }

        public static bool IsHorizontal(PlanarFace f)
        {
            return IsVertical(f.FaceNormal);
        }

        public static bool IsVertical(PlanarFace f)
        {
            return IsHorizontal(f.FaceNormal);
        }

        public static bool IsHorizontal(XYZ v)
        {
            return IsZero(v.Z);
        }

        public static bool IsVertical(XYZ v)
        {
            return IsZero(v.X) && IsZero(v.Y);
        }

        public static bool IsVertical(XYZ v, double tolerance)
        {
            return IsZero(v.X, tolerance)
              && IsZero(v.Y, tolerance);
        }

        public static bool IsHorizontal(Edge e)
        {
            XYZ p = e.Evaluate(0);
            XYZ q = e.Evaluate(1);
            return IsHorizontal(q - p);
        }

        public static bool IsZero(double a, double tolerance)
        {
            return tolerance > Math.Abs(a);
        }

        public static bool IsZero(double a)
        {
            return IsZero(a, _eps);
        }

        public static bool IsEqual(double a, double b)
        {
            return IsZero(b - a);
        }

        const double _eps = 1.0e-9;

        public static double Eps
        {
            get
            {
                return _eps;
            }
        }

        public static bool IsAlmostEqual(double value1, double value2)
        {
            return Math.Abs(value1 - value2) <= _eps;
        }

        #endregion


    }

    public static class JtPlaneExtensionMethods
    {
        public static double SignedDistanceTo(this Plane plane, XYZ p)
        {
            Debug.Assert(
              Utils.IsEqual(plane.Normal.GetLength(), 1),
              "expected normalised plane normal");

            XYZ v = p - plane.Origin;

            return plane.Normal.DotProduct(v);
        }
    }
    }
