﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using Autodesk.Revit.UI;
using Ideate.ModelessAddinSolution.Resources.Dialogs;

namespace Ideate.ModelessAddinSolution.CommandImpl
{
    /// <summary>
    /// Main controller for the application, does real work of starting the Application.
    /// </summary>
    class CommandController
    {
        #region Application Creation
        /// <summary>
        /// Returns the singalton reference to the this application.
        /// </summary>
        /// <returns></returns>
        internal static CommandController GetInstance()
        {
            return s_thisApp ?? (s_thisApp = new CommandController());
        }

        #endregion

        #region Methods
        /// <summary>
        /// Implements the OnStartup funtionality to get the application initialized.
        /// </summary>
        /// <param name="application"></param>
        /// <returns></returns>
        public Result OnStartup(UIControlledApplication application)
        {
            _mainWindow = null; // no dialog needed yet; the command will bring it
            s_thisApp = this;  // static access to this application instance

            return Result.Succeeded;
        }
        /// <summary>
        /// Implements the OnShutdown used to shutdown the application.
        /// </summary>
        /// <param name="application"></param>
        /// <returns></returns>
        public Result OnShutdown(UIControlledApplication application)
        {
            if (_mainWindow != null)
            {
                _mainWindow.Close();
                _mainWindow = null;
            }

            return Result.Succeeded;
        }

        /// <summary>
        /// Main entry to get the application started.
        /// </summary>
        /// <param name="commandData"></param>
        /// <returns></returns>
        public Result Execute(ExternalCommandData commandData)
        {
            bool success = false;

            if (_revitApp == null)
                _revitApp = commandData.Application;

            success = ShowWindow(_revitApp);

            return success ? Result.Succeeded : Result.Failed;
        }

        /// <summary>
        /// Creates the main applcation window using WPF
        /// </summary>
        /// <param name="upapp"></param>
        /// <returns></returns>
        private bool ShowWindow(UIApplication upapp)
        {
            bool show = false;

            if (_mainWindow != null)
                _mainWindow = null;

            // If we do not have a dialog yet, create and show it
            if (_mainWindow == null)
            {
                // We give the objects to the new dialog;
                // The dialog becomes the owner responsible fore disposing them, eventually.
                _mainWindow = new MainWindow();
                _mainWindow.ShowMainDialog();
                show = true;
            }

            return show;
        }
        #endregion

        #region Members
        // class instance
        internal static CommandController s_thisApp = null;

        /// <summary>
        /// Cached copy of the Revit UI Application object used to start the Addin Application.
        /// </summary>
        private UIApplication _revitApp = null;

        // ModelessForm instance
        private MainWindow _mainWindow = null;
        #endregion
    } // class CommandController  End
} // namespace End
