﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using Autodesk.Revit.UI;
using Ideate.ModelessAddinSolution.CommandImpl;

namespace Ideate.ModelessAddinSolution.ExternalApplication
{
    /// <summary>
    /// External Application class, has pass through methods to support Application Obfusaction.
    /// </summary>
    class Application : IExternalApplication
    {
        #region Implementation of IExternalApplication Interface
        /// <summary>
        /// Implements the OnStartup event
        /// </summary>
        /// <param name="application"></param>
        /// <returns></returns>
        public Result OnStartup(UIControlledApplication application)
        {
            return CommandController.GetInstance().OnStartup(application);
        }
        /// <summary>
        /// Implements the OnShutdown event
        /// </summary>
        /// <param name="application"></param>
        /// <returns></returns>
        public Result OnShutdown(UIControlledApplication application)
        {
            return CommandController.GetInstance().OnShutdown(application);
        }
        #endregion
    } // Class Application End
} // namespace  End
