﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using System;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Ideate.ModelessAddinSolution.CommandImpl;

namespace Ideate.ModelessAddinSolution.ExternalApplication
{
    /// <summary>
    /// Implements the Revit add-in interface IExternalCommand
    /// 
    /// Used to setup the addin owner or parent relationship using Ideates newer method
    /// by searching all open windows Revit has open.
    /// </summary>
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)]
    class SolutionWindowHandleCommand : IExternalCommand
    {
        /// <summary>
        /// Start the lauch of the Addin Application.
        /// </summary>
        /// <param name="commandData"></param>
        /// <param name="message"></param>
        /// <param name="elements"></param>
        /// <returns></returns>
        public virtual Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {
            try
            {
                CommandController.GetInstance().Execute(commandData);
                return Result.Succeeded;
            }
            catch (Exception ex)
            {
                System.Windows.Forms.MessageBox.Show("Command.Execute() Caught Exceptions: " + ex.Message);
                return Result.Failed;
            }
        }

    } // Class Command End

} // namespace End
