﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using System.Text;

using HWND = System.IntPtr;

namespace Ideate.ModelessAddinSolution.ExternalApplication
{
    internal class WindowName
    {
        /// <summary>
        /// Return the Windows main Title of Name
        /// </summary>
        /// <param name="hWnd"></param>
        /// <returns></returns>
        internal static string GetWindowName(HWND hWnd)
        {
            if (hWnd == null)
                return string.Empty;

            int length = LibUser32.GetWindowTextLength(hWnd);
            if (length == 0) return string.Empty;

            // get windows title string
            StringBuilder builder = new StringBuilder(length);
            LibUser32.GetWindowText(hWnd, builder, length + 1);

            return builder.ToString();
        }
    }
}
