﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Windows;
using System.Windows.Interop;
using Ideate.ModelessAddinSolution.ExternalApplication;

namespace Ideate.ModelessAddinSolution.Model
{
    internal class HandelInfo
    {
        internal static string Report(Window dlg, string header = "")
        {
            string eol = System.Environment.NewLine;
            string report = string.Empty;

            report += "--------------------------------------------------" + eol;
            report += string.Format("{0}", header) + eol;
            report += "--------------------------------------------------" + eol;
            report += "Revit:" + eol;
            report += "MainWindowHandle: " + Process.GetCurrentProcess().MainWindowHandle + eol;
            report += "Pid:              " + Process.GetCurrentProcess().Id + eol;
            report += "Name:             " + Process.GetCurrentProcess().MainWindowTitle + eol;

            IntPtr owner = new WindowInteropHelper(dlg).Owner;
            IntPtr addinHandel = new WindowInteropHelper(dlg).Handle;
            report += "--------------------------------------------------" + eol;
            report += "Addin:" + eol;
            report += "Owner Name:    " + WindowName.GetWindowName(owner) + eol;
            report += "Owner Handel:  " + owner.ToInt64() + eol;
            report += "Addin Name:    " + WindowName.GetWindowName(addinHandel) + eol;
            report += "Addin Handel:  " + addinHandel.ToInt64() + eol;


            return report;
        }

    } // End of HandelInfo Class
}
