﻿//------------------------------------------------------------------------------
//
// © 2008-2017 Ideate, Inc.
//
//------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Windows;
using System.Windows.Interop;
using Ideate.ModelessAddinSolution.ExternalApplication;

namespace Ideate.ModelessAddinSolution.Resources.Dialogs
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            this.Title = string.Format("{0} {1}", this.Title, ++_sDlgCnt);

            string eol = System.Environment.NewLine;
            string instructions = "Instructions to show the focus issue and solution." + eol;
            instructions += "" + eol;

            instructions += "To see the solution" + eol;
            instructions += "   - Press the \"Start Dialog\" button" + eol;
            instructions += "   - Close the new modal dialog" + eol;
            instructions += "   - Close the Add-In dialog" + eol;
            instructions += "   - Revit stays on top" + eol;
            instructions += "" + eol;

            instructions += "To see the Focus issue" + eol;
            instructions += "   - Uncheck the \"Fix Focus Issue\" checkbox" + eol;
            instructions += "   - Press the \"Start Dialog\" button" + eol;
            instructions += "   - Close the new dialog" + eol;
            instructions += "   - Close the Add-In dialog" + eol;
            instructions += "   - Revit is on longer on top" + eol;
            instructions += "" + eol;


            TextBox.Text = instructions;
        }

        /// <summary>
        /// Sets up the dialogs ownership and starts it as a Modeless application.
        /// </summary>
        internal void ShowMainDialog()
        {
            // WPF Dialog
            if (this.Owner == null)
            {
                WindowHandleSearch handle = WindowHandleSearch.MainWindowHandle;
                handle.SetAsOwner(this);
            }
            else
                this.Owner = Owner;

            // show the dialog as a modeless Addin.
            this.Show();
        }

        #region Event Handlers
        /// <summary>
        /// Starts a Modal Dialog, used to reproduce the Revit 2018 loss of focus issue.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void _btn_OnClick(object sender, RoutedEventArgs e)
        {
            ModalDlg dlg = new ModalDlg();
            dlg.Owner = this;
            dlg.ShowDialog();
        }

        /// <summary>
        /// Use the OnClose event to ensure Revit is brought back into focus.
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosing(CancelEventArgs e)
        {
            // do the base work first.
            base.OnClosing(e);

            // Set Revit to the foreground
            try
            {
                if (ChkBox.IsChecked == true)
                {
                    IntPtr ownerIntPtr = new WindowInteropHelper(this).Owner;
                    if (ownerIntPtr != IntPtr.Zero)
                        LibUser32.SetForegroundWindow(ownerIntPtr);
                }
            }
            catch (Exception)
            { }
        }
        #endregion

        #region Members
        private static int _sDlgCnt = 0;
        #endregion
    }
}
