#region Namespaces
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Windows.Forms;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.UI.Selection;
using ClipperLib;
using Polygon = System.Collections.Generic.List<ClipperLib.IntPoint>;
using Polygons = System.Collections.Generic.List<System.Collections.Generic.List<ClipperLib.IntPoint>>;
#endregion

namespace RvtClipper
{
    [Transaction(TransactionMode.Manual)]
    public class Command : IExternalCommand
    {

       
        /// <summary>
        /// Revit external command mainline.
        /// </summary>
        public Result Execute(ExternalCommandData commandData, ref string message, ElementSet elements)
        {

            UIDocument uidoc = commandData.Application.ActiveUIDocument;
            Document doc = uidoc.Document;

            Clipper c;
            Polygons clip;
            Polygons subject;
            if(!GetUserInput(uidoc, out c, out clip, out subject))
            {
                return Result.Succeeded;
            }

            using (TransactionGroup tg = new TransactionGroup(doc, "Clipper"))
            {
                tg.Start();

                using (UIOptions opt = new UIOptions(uidoc, c, clip))
                {
                    opt.ShowDialog();

                }

                tg.Assimilate();
            }



            return Result.Succeeded;
        }



        private static bool GetUserInput(UIDocument uidoc, out Clipper c, out Polygons clip, out Polygons subj)
        {
            //Get two sketchbased elements like Floor, Railing, Ceiling etc
            //Walls also have a sketch after its profile has been modified but so far untested

            c = new Clipper();
            subj = null;
            clip = null;
            Sketch sketch1 = Util.GetSketch(uidoc);
            if (sketch1 == null)
            {
                TaskDialog.Show("Select", "First pick is not a sketchbased element or has more than one associated sketch");
                return false;
            }

            Sketch sketch2 = Util.GetSketch(uidoc);
            if (sketch2 == null)
            {
                TaskDialog.Show("Select", "Second pick is not a sketchbased element or has more than one associated sketch");
                return false;
            }

            subj = Util.GetBoundaryLoops(sketch1);
            clip = Util.GetBoundaryLoops(sketch2);
            Polygons intersection = new Polygons();

            c.AddPaths(subj, PolyType.ptSubject, true);
            c.AddPaths(clip, PolyType.ptClip, true);

            return true;
        }

        ///// <summary>
        ///// Retrieve the boundary loops of the given sketch 
        ///// </summary>
        //Polygons GetBoundaryLoops(Sketch sketch)
        //{
        //    int n;
        //    Polygons polys = null;

        //    CurveArrArray loops = sketch.Profile;

        //    n = loops.Size;
        //    polys = new Polygons(n);

        //    foreach (CurveArray loop in loops)
        //    {
        //        n = loop.Size;
        //        Polygon poly = new Polygon(n);

        //        foreach (Curve edge in loop)
        //        {
        //            IList<XYZ> pts = edge.Tessellate();

        //            n = pts.Count;

        //            foreach (XYZ p in pts)
        //            {
        //                poly.Add(Util.GetIntPoint(p));
        //            }
        //        }
        //        polys.Add(poly);
        //    }

        //    return polys;
        //}

        //private Sketch GetSketch(UIDocument uidoc)
        //{
        //    ElementClassFilter filter = new ElementClassFilter(typeof(Sketch));
        //    Reference rf = null;
        //    Sketch sketch = null;
        //    try
        //    {
        //        rf = uidoc.Selection.PickObject(ObjectType.Element, "Pick a sketchbased element");
        //    }
        //    catch
        //    {
        //        return sketch;
        //    }

        //    Element e = uidoc.Document.GetElement(rf);
        //    IList<ElementId> sketches = e.GetDependentElements(filter);

        //    if (sketches.Count == 1)
        //    {                          
        //        sketch = (Sketch)uidoc.Document.GetElement(sketches[0]);
        //    }

        //    return sketch;
        //}

    }

}
