﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Text
Imports System.Reflection
Imports System.Collections.Generic
Imports System.Collections.ObjectModel

Imports Autodesk.Revit
Imports Autodesk.Revit.Elements

''' <summary> 
''' Data class which stores the main information for exporting dwg format 
''' </summary> 
Public Class ExportDWGData
    Inherits ExportDataWithViews
#Region "Class Memeber Variables"
    ''' <summary> 
    ''' Data class ExportOptionsData 
    ''' </summary> 
    Private m_exportOptionsData As ExportDWGOptionsData

    ''' <summary> 
    ''' String list of AutoCAD versions 
    ''' </summary> 
    Private m_fileVersion As List(Of [String])

    ''' <summary> 
    ''' List of Autodesk.Revit.Enums.ACADVersion defined in Revit 
    ''' </summary> 
    Private m_enumFileVersion As List(Of Autodesk.Revit.Enums.ACADVersion)

    ''' <summary> 
    ''' File version option to export 
    ''' </summary> 
    Private m_exportFileVersion As Autodesk.Revit.Enums.ACADVersion
#End Region

#Region "Class Properties"
    ''' <summary> 
    ''' Data class ExportOptionsData 
    ''' </summary> 
    Public Property ExportOptionsData() As ExportDWGOptionsData
        Get
            Return m_exportOptionsData
        End Get
        Set(ByVal value As ExportDWGOptionsData)
            m_exportOptionsData = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of AutoCAD versions 
    ''' </summary> 
    Public ReadOnly Property FileVersion() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_fileVersion)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of Autodesk.Revit.Enums.ACADVersion defined in Revit 
    ''' </summary> 
    Public ReadOnly Property EnumFileVersion() As ReadOnlyCollection(Of Autodesk.Revit.Enums.ACADVersion)
        Get
            Return New ReadOnlyCollection(Of Autodesk.Revit.Enums.ACADVersion)(m_enumFileVersion)
        End Get
    End Property

    ''' <summary> 
    ''' File version option to export 
    ''' </summary> 
    Public Property ExportFileVersion() As Autodesk.Revit.Enums.ACADVersion
        Get
            Return m_exportFileVersion
        End Get
        Set(ByVal value As Autodesk.Revit.Enums.ACADVersion)
            m_exportFileVersion = value
        End Set
    End Property
#End Region

#Region "Class Member Methods"
    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="commandData">Revit command data</param> 
    ''' <param name="exportFormat">Format to export</param> 
    Public Sub New(ByVal commandData As ExternalCommandData, ByVal exportFormat As ExportFormat)
        MyBase.New(commandData, exportFormat)
        m_exportOptionsData = New ExportDWGOptionsData()

        Initialize()
    End Sub

    ''' <summary> 
    ''' Initialize the variables 
    ''' </summary> 
    Private Sub Initialize()
        'AutoCAD versions 
        m_fileVersion = New List(Of [String])()
        m_enumFileVersion = New List(Of Autodesk.Revit.Enums.ACADVersion)()
        m_fileVersion.Add("AutoCAD 2007 DWG Files (*.dwg)")
        m_enumFileVersion.Add(Autodesk.Revit.Enums.ACADVersion.R2007)
        m_fileVersion.Add("AutoCAD 2004 DWG Files (*.dwg)")
        m_enumFileVersion.Add(Autodesk.Revit.Enums.ACADVersion.R2004)
        m_fileVersion.Add("AutoCAD 2000 DWG Files (*.dwg)")
        m_enumFileVersion.Add(Autodesk.Revit.Enums.ACADVersion.R2000)

        Dim tmp As New StringBuilder()
        For Each version As [String] In m_fileVersion
            tmp.Append(version & "|*.dwg|")
        Next
        m_filter = tmp.ToString().TrimEnd("|"c)
        m_title = "Export DWG"
    End Sub

    ''' <summary> 
    ''' Collect the parameters and export 
    ''' </summary> 
    ''' <returns></returns> 
    Public Overloads Overrides Function Export() As Boolean
        MyBase.Export()

        Dim exported As Boolean = False
        'parameter : ViewSet views 
        Dim views As New ViewSet()
        If m_currentViewOnly Then
            views.Insert(m_activeDoc.ActiveView)
        Else
            views = m_selectViewsData.SelectedViews
        End If

        'parameter : DWGExportOptions dwgExportOptions 
        Dim dwgExportOptions As New DWGExportOptions()
        dwgExportOptions.ExportingAreas = m_exportOptionsData.ExportAreas
        dwgExportOptions.ExportOfSolids = m_exportOptionsData.ExportSolid
        dwgExportOptions.FileVersion = m_exportFileVersion
        dwgExportOptions.LayerMapping = m_exportOptionsData.ExportLayerMapping
        dwgExportOptions.LineScaling = m_exportOptionsData.ExportLineScaling
        dwgExportOptions.MergedViews = m_exportOptionsData.ExportMergeFiles
        dwgExportOptions.PropOverrides = m_exportOptionsData.ExportLayersAndProperties
        dwgExportOptions.SharedCoords = m_exportOptionsData.ExportCoorSystem
        dwgExportOptions.TargetUnit = m_exportOptionsData.ExportUnit

        'Export 
        exported = m_activeDoc.Export(m_exportFolder, m_exportFileName, views, dwgExportOptions)

        Return exported
    End Function
#End Region
End Class