﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Text
Imports System.Collections.Generic
Imports System.Collections.ObjectModel

Imports Autodesk.Revit

''' <summary> 
''' Data class which stores lower priority information for exporting dwg format 
''' </summary> 
Public Class ExportDWGOptionsData
#Region "Class Memeber Variables"
    ''' <summary> 
    ''' String list of Layers and properties used in UI 
    ''' </summary> 
    Private m_layersAndProperties As List(Of [String])

    ''' <summary> 
    ''' List of Autodesk.Revit.Enums.PropOverrideMode 
    ''' </summary> 
    Private m_enumLayersAndProperties As List(Of Autodesk.Revit.Enums.PropOverrideMode)

    ''' <summary> 
    ''' String list of Layer Settings used in UI 
    ''' </summary> 
    Private m_layerMapping As List(Of [String])

    ''' <summary> 
    ''' String list of layer settings values defined in Revit 
    ''' </summary> 
    Private m_enumLayerMapping As List(Of [String])

    ''' <summary> 
    ''' Layer setting option to export 
    ''' </summary> 
    Private m_exportLayerMapping As [String]

    ''' <summary> 
    ''' String list of Linetype scaling used in UI 
    ''' </summary> 
    Private m_lineScaling As List(Of [String])

    ''' <summary> 
    ''' PropOverrideMode Option to export 
    ''' </summary> 
    Private m_exportLayersAndProperties As Autodesk.Revit.Enums.PropOverrideMode

    ''' <summary> 
    ''' List of Autodesk.Revit.Enums.LineScaling defined in Revit 
    ''' </summary> 
    Private m_enumLineScaling As List(Of Autodesk.Revit.Enums.LineScaling)

    ''' <summary> 
    ''' Line scaling option to export 
    ''' </summary> 
    Private m_exportLineScaling As Autodesk.Revit.Enums.LineScaling

    ''' <summary> 
    ''' String list of Coordinate system basis 
    ''' </summary> 
    Private m_coorSystem As List(Of [String])

    ''' <summary> 
    ''' List of values whether to use shared coordinate system 
    ''' </summary> 
    Private m_enumCoorSystem As List(Of Boolean)

    ''' <summary> 
    ''' Coordinate system basis option to export 
    ''' </summary> 
    Private m_exportCoorSystem As Boolean

    ''' <summary> 
    ''' String list of DWG unit 
    ''' </summary> 
    Private m_units As List(Of [String])

    ''' <summary> 
    ''' List of Autodesk.Revit.Enums.ExportUnit values defined in Revit 
    ''' </summary> 
    Private m_enumUnits As List(Of Autodesk.Revit.Enums.ExportUnit)

    ''' <summary> 
    ''' Export unit option to export 
    ''' </summary> 
    Private m_exportUnit As Autodesk.Revit.Enums.ExportUnit

    ''' <summary> 
    ''' String list of solid used in UI 
    ''' </summary> 
    Private m_solids As List(Of [String])

    ''' <summary> 
    ''' List of Autodesk.Revit.Enums.SolidGeometry defined in Revit 
    ''' </summary> 
    Private m_enumSolids As List(Of Autodesk.Revit.Enums.SolidGeometry)

    ''' <summary> 
    ''' Solid geometry option to export 
    ''' </summary> 
    Private m_exportSolid As Autodesk.Revit.Enums.SolidGeometry

    ''' <summary> 
    ''' Whether to create separate files for each view/sheet 
    ''' </summary> 
    Private m_exportMergeFiles As Boolean

    'Export rooms and areas as polylines 
    Private m_exportAreas As Boolean
#End Region

#Region "Class Properties"
    ''' <summary> 
    ''' String collection of Layers and properties used in UI 
    ''' </summary> 
    Public ReadOnly Property LayersAndProperties() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_layersAndProperties)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of Autodesk.Revit.Enums.PropOverrideMode 
    ''' </summary> 
    Public ReadOnly Property EnumLayersAndProperties() As ReadOnlyCollection(Of Autodesk.Revit.Enums.PropOverrideMode)
        Get
            Return New ReadOnlyCollection(Of Autodesk.Revit.Enums.PropOverrideMode)(m_enumLayersAndProperties)
        End Get
    End Property

    ''' <summary> 
    ''' PropOverrideMode Option to export 
    ''' </summary> 
    Public Property ExportLayersAndProperties() As Autodesk.Revit.Enums.PropOverrideMode
        Get
            Return m_exportLayersAndProperties
        End Get
        Set(ByVal value As Autodesk.Revit.Enums.PropOverrideMode)
            m_exportLayersAndProperties = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of Layer Settings used in UI 
    ''' </summary> 
    Public ReadOnly Property LayerMapping() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_layerMapping)
        End Get
    End Property

    ''' <summary> 
    ''' String collection of layer settings values defined in Revit 
    ''' </summary> 
    Public ReadOnly Property EnumLayerMapping() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_enumLayerMapping)
        End Get
    End Property

    ''' <summary> 
    ''' Layer setting option to export 
    ''' </summary> 
    Public Property ExportLayerMapping() As [String]
        Get
            Return m_exportLayerMapping
        End Get
        Set(ByVal value As [String])
            m_exportLayerMapping = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of Linetype scaling used in UI 
    ''' </summary> 
    Public ReadOnly Property LineScaling() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_lineScaling)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of Autodesk.Revit.Enums.LineScaling defined in Revit 
    ''' </summary> 
    Public ReadOnly Property EnumLineScaling() As ReadOnlyCollection(Of Autodesk.Revit.Enums.LineScaling)
        Get
            Return New ReadOnlyCollection(Of Autodesk.Revit.Enums.LineScaling)(m_enumLineScaling)
        End Get
    End Property

    ''' <summary> 
    ''' Line scaling option to export 
    ''' </summary> 
    Public Property ExportLineScaling() As Autodesk.Revit.Enums.LineScaling
        Get
            Return m_exportLineScaling
        End Get
        Set(ByVal value As Autodesk.Revit.Enums.LineScaling)
            m_exportLineScaling = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of Coordinate system basis 
    ''' </summary> 
    Public ReadOnly Property CoorSystem() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_coorSystem)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of values whether to use shared coordinate system 
    ''' </summary> 
    Public ReadOnly Property EnumCoorSystem() As ReadOnlyCollection(Of Boolean)
        Get
            Return New ReadOnlyCollection(Of Boolean)(m_enumCoorSystem)
        End Get
    End Property

    ''' <summary> 
    ''' Coordinate system basis option to export 
    ''' </summary> 
    Public Property ExportCoorSystem() As Boolean
        Get
            Return m_exportCoorSystem
        End Get
        Set(ByVal value As Boolean)
            m_exportCoorSystem = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of DWG unit 
    ''' </summary> 
    Public ReadOnly Property Units() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_units)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of Autodesk.Revit.Enums.ExportUnit values defined in Revit 
    ''' </summary> 
    Public ReadOnly Property EnumUnits() As ReadOnlyCollection(Of Autodesk.Revit.Enums.ExportUnit)
        Get
            Return New ReadOnlyCollection(Of Autodesk.Revit.Enums.ExportUnit)(m_enumUnits)
        End Get
    End Property

    ''' <summary> 
    ''' Export unit option to export 
    ''' </summary> 
    Public Property ExportUnit() As Autodesk.Revit.Enums.ExportUnit
        Get
            Return m_exportUnit
        End Get
        Set(ByVal value As Autodesk.Revit.Enums.ExportUnit)
            m_exportUnit = value
        End Set
    End Property

    ''' <summary> 
    ''' String collection of solid used in UI 
    ''' </summary> 
    Public ReadOnly Property Solids() As ReadOnlyCollection(Of [String])
        Get
            Return New ReadOnlyCollection(Of [String])(m_solids)
        End Get
    End Property

    ''' <summary> 
    ''' Collection of Autodesk.Revit.Enums.SolidGeometry defined in Revit 
    ''' </summary> 
    Public ReadOnly Property EnumSolids() As ReadOnlyCollection(Of Autodesk.Revit.Enums.SolidGeometry)
        Get
            Return New ReadOnlyCollection(Of Autodesk.Revit.Enums.SolidGeometry)(m_enumSolids)
        End Get
    End Property

    ''' <summary> 
    ''' Property of solid geometry option to export 
    ''' </summary> 
    Public Property ExportSolid() As Autodesk.Revit.Enums.SolidGeometry
        Get
            Return m_exportSolid
        End Get
        Set(ByVal value As Autodesk.Revit.Enums.SolidGeometry)
            m_exportSolid = value
        End Set
    End Property

    ''' <summary> 
    ''' Export rooms and areas as polylines 
    ''' </summary> 
    Public Property ExportAreas() As Boolean
        Get
            Return m_exportAreas
        End Get
        Set(ByVal value As Boolean)
            m_exportAreas = value
        End Set
    End Property

    ''' <summary> 
    ''' Whether to create separate files for each view/sheet 
    ''' </summary> 
    Public Property ExportMergeFiles() As Boolean
        Get
            Return m_exportMergeFiles
        End Get
        Set(ByVal value As Boolean)
            m_exportMergeFiles = value
        End Set
    End Property
#End Region


#Region "Class Member Methods"
    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    Public Sub New()
        Initialize()
    End Sub

    ''' <summary> 
    ''' Initialize values 
    ''' </summary> 
    Private Sub Initialize()
        'Layers and properties: 
        m_layersAndProperties = New List(Of [String])()
        m_enumLayersAndProperties = New List(Of Autodesk.Revit.Enums.PropOverrideMode)()
        m_layersAndProperties.Add("Category properties BYLAYER, overrides BYENTITY")
        m_enumLayersAndProperties.Add(Autodesk.Revit.Enums.PropOverrideMode.ByEntity)
        m_layersAndProperties.Add("All properties BYLAYER, no overrides")
        m_enumLayersAndProperties.Add(Autodesk.Revit.Enums.PropOverrideMode.ByLayer)
        m_layersAndProperties.Add("All properties BYLAYER, new Layers for overrides")
        m_enumLayersAndProperties.Add(Autodesk.Revit.Enums.PropOverrideMode.NewLayer)

        'Layer Settings: 
        m_layerMapping = New List(Of [String])()
        m_enumLayerMapping = New List(Of [String])()
        m_layerMapping.Add("AIA - American Institute of Architects standard")
        m_enumLayerMapping.Add("AIA")
        m_layerMapping.Add("ISO13567 - ISO standard 13567")
        m_enumLayerMapping.Add("ISO13567")
        m_layerMapping.Add("CP83 - Singapore standard 83")
        m_enumLayerMapping.Add("CP83")
        m_layerMapping.Add("BS1192 - British standard 1192")
        m_enumLayerMapping.Add("BS1192")

        'Linetype scaling: 
        m_lineScaling = New List(Of [String])()
        m_enumLineScaling = New List(Of Autodesk.Revit.Enums.LineScaling)()
        m_lineScaling.Add("Scaled Linetype definitions")
        m_enumLineScaling.Add(Autodesk.Revit.Enums.LineScaling.ViewScale)
        m_lineScaling.Add("ModelSpace (PSLTSCALE = 0)")
        m_enumLineScaling.Add(Autodesk.Revit.Enums.LineScaling.ModelSpace)
        m_lineScaling.Add("Paperspace (PSLTSCALE = 1)")
        m_enumLineScaling.Add(Autodesk.Revit.Enums.LineScaling.PaperSpace)

        'Coordinate system basis 
        m_coorSystem = New List(Of [String])()
        m_enumCoorSystem = New List(Of Boolean)()
        m_coorSystem.Add("Project Internal")
        m_enumCoorSystem.Add(False)
        m_coorSystem.Add("Shared")
        m_enumCoorSystem.Add(True)

        'One DWG unit 
        m_units = New List(Of [String])()
        m_enumUnits = New List(Of Autodesk.Revit.Enums.ExportUnit)()
        m_units.Add(Autodesk.Revit.Enums.ExportUnit.Foot.ToString().ToLower())
        m_enumUnits.Add(Autodesk.Revit.Enums.ExportUnit.Foot)
        m_units.Add(Autodesk.Revit.Enums.ExportUnit.Inch.ToString().ToLower())
        m_enumUnits.Add(Autodesk.Revit.Enums.ExportUnit.Inch)
        m_units.Add(Autodesk.Revit.Enums.ExportUnit.Meter.ToString().ToLower())
        m_enumUnits.Add(Autodesk.Revit.Enums.ExportUnit.Meter)
        m_units.Add(Autodesk.Revit.Enums.ExportUnit.Centimeter.ToString().ToLower())
        m_enumUnits.Add(Autodesk.Revit.Enums.ExportUnit.Centimeter)
        m_units.Add(Autodesk.Revit.Enums.ExportUnit.Millimeter.ToString().ToLower())
        m_enumUnits.Add(Autodesk.Revit.Enums.ExportUnit.Millimeter)

        m_solids = New List(Of [String])()
        m_enumSolids = New List(Of Autodesk.Revit.Enums.SolidGeometry)()
        m_solids.Add("Export as polymesh")
        m_enumSolids.Add(Autodesk.Revit.Enums.SolidGeometry.Polymesh)
        m_solids.Add("Export as ACIS solids")
        m_enumSolids.Add(Autodesk.Revit.Enums.SolidGeometry.ACIS)
    End Sub
#End Region
End Class