﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms

''' <summary> 
''' Provide a dialog which provides the options of lower priority information for exporting dwg format 
''' </summary> 
Partial Public Class ExportDWGOptionsForm
    Inherits Form
    ''' <summary> 
    ''' data class 
    ''' </summary> 
    Private m_exportOptionsData As ExportDWGOptionsData

    ''' <summary> 
    ''' Whether export the current view only 
    ''' </summary> 
    Private m_contain3DView As Boolean

    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="exportOptionsData">Data class object</param> 
    ''' <param name="contain3DView">If views to export contain 3D views</param> 
    Public Sub New(ByVal exportOptionsData As ExportDWGOptionsData, ByVal contain3DView As Boolean)
        InitializeComponent()
        m_exportOptionsData = exportOptionsData
        m_contain3DView = contain3DView
        InitializeControl()
    End Sub

    ''' <summary> 
    ''' Initialize values and status of controls 
    ''' </summary> 
    Private Sub InitializeControl()
        comboBoxLayersAndProperties.DataSource = m_exportOptionsData.LayersAndProperties
        comboBoxLayersAndProperties.SelectedIndex = 0
        comboBoxLayerSettings.DataSource = m_exportOptionsData.LayerMapping
        comboBoxLayerSettings.SelectedIndex = 0
        comboBoxLinetypeScaling.DataSource = m_exportOptionsData.LineScaling
        comboBoxLinetypeScaling.SelectedIndex = 2
        comboBoxCoorSystem.DataSource = m_exportOptionsData.CoorSystem
        comboBoxCoorSystem.SelectedIndex = 0
        comboBoxDWGUnit.DataSource = m_exportOptionsData.Units
        comboBoxDWGUnit.SelectedIndex = 1
        comboBoxSolids.DataSource = m_exportOptionsData.Solids
        comboBoxSolids.SelectedIndex = 0
        checkBoxMergeViews.Checked = m_exportOptionsData.ExportMergeFiles
        checkBoxMergeViews.Text = "Merge all views in one file (via XRefs)."
        If m_contain3DView Then
            comboBoxSolids.Enabled = True
        Else
            comboBoxSolids.Enabled = False
        End If
    End Sub

    ''' <summary> 
    ''' Transfer information back to ExportOptionData class 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
        m_exportOptionsData.ExportLayersAndProperties = m_exportOptionsData.EnumLayersAndProperties(comboBoxLayersAndProperties.SelectedIndex)
        m_exportOptionsData.ExportLayerMapping = m_exportOptionsData.EnumLayerMapping(comboBoxLayerSettings.SelectedIndex)
        m_exportOptionsData.ExportLineScaling = m_exportOptionsData.EnumLineScaling(comboBoxLinetypeScaling.SelectedIndex)
        m_exportOptionsData.ExportCoorSystem = m_exportOptionsData.EnumCoorSystem(comboBoxCoorSystem.SelectedIndex)
        m_exportOptionsData.ExportUnit = m_exportOptionsData.EnumUnits(comboBoxDWGUnit.SelectedIndex)
        m_exportOptionsData.ExportSolid = m_exportOptionsData.EnumSolids(comboBoxSolids.SelectedIndex)
        m_exportOptionsData.ExportAreas = checkBoxExportingAreas.Checked
        m_exportOptionsData.ExportMergeFiles = checkBoxMergeViews.Checked

        Me.Close()
    End Sub
End Class