﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections.Generic
Imports System.Text

Imports Autodesk.Revit
Imports Autodesk.Revit.Elements

''' <summary> 
''' Base data class which stores the common information for exporting view related format 
''' </summary> 
Public Class ExportDataWithViews
    Inherits ExportData
#Region "Class Memeber Variables"
    ''' <summary> 
    ''' Data class SelectViewsData 
    ''' </summary> 
    Protected m_selectViewsData As SelectViewsData

    ''' <summary> 
    ''' Views to export 
    ''' </summary> 
    Private m_exportViews As ViewSet

    ''' <summary> 
    ''' Whether to export current view only 
    ''' </summary> 
    Protected m_currentViewOnly As Boolean
#End Region

#Region "Class Properties"
    ''' <summary> 
    ''' Data class SelectViewsData 
    ''' </summary> 
    Public Property SelectViewsData() As SelectViewsData
        Get
            Return m_selectViewsData
        End Get
        Set(ByVal value As SelectViewsData)
            m_selectViewsData = value
        End Set
    End Property

    ''' <summary> 
    ''' Views to export 
    ''' </summary> 
    Public Property ExportViews() As ViewSet
        Get
            Return m_exportViews
        End Get
        Set(ByVal value As ViewSet)
            m_exportViews = value
        End Set
    End Property

    ''' <summary> 
    ''' Whether to export current view only 
    ''' </summary> 
    Public Property CurrentViewOnly() As Boolean
        Get
            Return m_currentViewOnly
        End Get
        Set(ByVal value As Boolean)
            m_currentViewOnly = value
        End Set
    End Property
#End Region

#Region "Class Member Methods"
    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="commandData">Revit command data</param> 
    ''' <param name="exportFormat">Format to export</param> 
    Public Sub New(ByVal commandData As ExternalCommandData, ByVal exportFormat As ExportFormat)
        MyBase.New(commandData, exportFormat)
        m_selectViewsData = New SelectViewsData(commandData)

        Initialize()
    End Sub

    ''' <summary> 
    ''' Initialize the variables 
    ''' </summary> 
    Private Sub Initialize()
        'Views to export 
        m_exportViews = New ViewSet()
    End Sub
#End Region
End Class