﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.IO

''' <summary> 
''' It contains a dialog which provides the options of common information for export 
''' </summary> 
Partial Public Class ExportWithViewsForm
    Inherits Form
    ' Data class object of ExportDataWithViews 
    Private m_exportData As ExportDataWithViews

    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="data"></param> 
    Public Sub New(ByVal data As ExportDataWithViews)
        m_exportData = data
        InitializeComponent()
        InitializeControls()
    End Sub

    ''' <summary> 
    ''' Initialize values and status of controls 
    ''' </summary> 
    Private Sub InitializeControls()
        textBoxSaveAs.Text = (m_exportData.ExportFolder & "\") + m_exportData.ExportFileName

        radioButtonCurrentView.Checked = True

        ' Initialize the title 
        Me.Text = m_exportData.Title
    End Sub

    ''' <summary> 
    ''' Provide the export option dialog 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonOptions_Click(ByVal sender As Object, ByVal e As EventArgs)
        ' Export dwg 
        If m_exportData.ExportFormat = ExportFormat.DWG Then
            Dim contain3DView As Boolean = False

            If radioButtonCurrentView.Checked Then
                If m_exportData.Is3DView Then
                    contain3DView = True
                End If
            Else
                If m_exportData.SelectViewsData.Contain3DView Then
                    contain3DView = True
                End If
            End If

            Dim exportDWGData As ExportDWGData = TryCast(m_exportData, ExportDWGData)
            Using exportOptionsForm As New ExportDWGOptionsForm(exportDWGData.ExportOptionsData, contain3DView)
                exportOptionsForm.ShowDialog()
            End Using
            ' Export dgn 
            'ElseIf m_exportData.ExportFormat = ExportFormat.DGN Then
            '    Dim exportDGNData As ExportDGNData = TryCast(m_exportData, ExportDGNData)
            '    Using exportOptionsForm As New ExportDGNOptionsForm(exportDGNData)
            '        exportOptionsForm.ShowDialog()
            '    End Using
            'Else
            '    ' Export 2D DWF 
            '    Dim export2DDWFData As Export2DDWFData = TryCast(m_exportData, Export2DDWFData)
            '    Using exportOptionsForm As New Export2DDWFOptionForm(export2DDWFData)
            '        exportOptionsForm.ShowDialog()
            '    End Using
        End If
    End Sub

    ''' <summary> 
    ''' Provide the views selecting dialog 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonSelectViews_Click(ByVal sender As Object, ByVal e As EventArgs)
        Using selectViewsForm As New SelectViewsForm(m_exportData.SelectViewsData)
            m_exportData.SelectViewsData.SelectedViews.Clear()
            selectViewsForm.ShowDialog()
            If m_exportData.SelectViewsData.SelectedViews.Size = 0 Then
                radioButtonCurrentView.Checked = True
            Else
                radioButtonCurrentView.Checked = False
            End If
        End Using
    End Sub

    ''' <summary> 
    ''' Specify a file to export into 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonBrowser_Click(ByVal sender As Object, ByVal e As EventArgs)
        Dim fileName As [String] = [String].Empty
        Dim filterIndex As Integer = -1

        Dim result As DialogResult = MainData.ShowSaveDialog(m_exportData, fileName, filterIndex)
        If result <> DialogResult.Cancel Then
            textBoxSaveAs.Text = fileName
            If m_exportData.ExportFormat = ExportFormat.DWG Then
                Dim exportDWGData As ExportDWGData = TryCast(m_exportData, ExportDWGData)
                exportDWGData.ExportFileVersion = exportDWGData.EnumFileVersion(filterIndex - 1)
            End If
        End If
    End Sub

    ''' <summary> 
    ''' Change the status of buttonSelectViews according to the selection 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub radioButtonSelectView_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs)
        buttonSelectViews.Enabled = radioButtonSelectView.Checked
    End Sub

    ''' <summary> 
    ''' Transfer information back to ExportData class and execute EXPORT operation 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonSave_Click(ByVal sender As Object, ByVal e As EventArgs)
        If ValidateExportFolder() Then
            m_exportData.CurrentViewOnly = Not radioButtonSelectView.Checked

            Try
                Dim exported As Boolean = m_exportData.Export()
                If Not exported Then
                    MessageBox.Show("This project cannot be exported to " & m_exportData.ExportFileName & " in current settings.", "Export", MessageBoxButtons.OK, MessageBoxIcon.Warning)
                End If
            Catch ex As Exception
                MessageBox.Show(ex.ToString(), "Export Failed", MessageBoxButtons.OK, MessageBoxIcon.Warning)
            End Try

            Me.DialogResult = DialogResult.OK
            Me.Close()
        End If
    End Sub

    ''' <summary> 
    ''' Check whether the folder specified is valid 
    ''' </summary> 
    ''' <returns></returns> 
    Private Function ValidateExportFolder() As [Boolean]
        Dim fileNameFull As [String] = textBoxSaveAs.Text
        'If the textBoxSaveAs is empty 
        If [String].IsNullOrEmpty(fileNameFull) Then
            MessageBox.Show("Please specify the folder and file name!", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information)
            textBoxSaveAs.Focus()
            Return False
        End If

        'If has file name 
        If Not fileNameFull.Contains("\") Then
            MessageBox.Show("Please specify file name!", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information)
            textBoxSaveAs.Focus()
            Return False
        End If

        'Whether the folder exists 
        Dim folder As [String] = Path.GetDirectoryName(fileNameFull)
        If Not Directory.Exists(folder) Then
            MessageBox.Show("The specified folder does not exist!", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information)
            textBoxSaveAs.Focus()
            Return False
        End If

        m_exportData.ExportFileName = Path.GetFileNameWithoutExtension(fileNameFull)
        m_exportData.ExportFolder = folder

        Return True
    End Function
End Class