﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Text

Imports Autodesk.Revit
Imports Autodesk.Revit.Elements

''' <summary> 
''' Data class which stores views information for export 
''' </summary> 
Public Class SelectViewsData
#Region "Class Memeber Variables"
    ''' <summary> 
    ''' Revit command data 
    ''' </summary> 
    Private m_commandData As ExternalCommandData

    ''' <summary> 
    ''' All printable views(except sheets) 
    ''' </summary> 
    Private m_printableViews As ViewSet

    ''' <summary> 
    ''' All printable sheets 
    ''' </summary> 
    Private m_printableSheets As ViewSet

    ''' <summary> 
    ''' All selected views in UI 
    ''' </summary> 
    Private m_selectedViews As ViewSet

    ''' <summary> 
    ''' Whether contain 3D view in selected views 
    ''' </summary> 
    Private m_contain3DView As Boolean
#End Region

#Region "Class Properties"
    ''' <summary> 
    ''' All printable views(except sheets) 
    ''' </summary> 
    Public Property PrintableViews() As ViewSet
        Get
            Return m_printableViews
        End Get
        Set(ByVal value As ViewSet)
            m_printableViews = value
        End Set
    End Property

    ''' <summary> 
    ''' All printable sheets 
    ''' </summary> 
    Public Property PrintableSheets() As ViewSet
        Get
            Return m_printableSheets
        End Get
        Set(ByVal value As ViewSet)
            m_printableSheets = value
        End Set
    End Property

    ''' <summary> 
    ''' All selected views in UI 
    ''' </summary> 
    Public Property SelectedViews() As ViewSet
        Get
            Return m_selectedViews
        End Get
        Set(ByVal value As ViewSet)
            m_selectedViews = value
        End Set
    End Property

    ''' <summary> 
    ''' Whether contain 3D view in selected views 
    ''' </summary> 
    Public Property Contain3DView() As Boolean
        Get
            Return m_contain3DView
        End Get
        Set(ByVal value As Boolean)
            m_contain3DView = value
        End Set
    End Property
#End Region

    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="commandData"></param> 
    Public Sub New(ByVal commandData As ExternalCommandData)
        m_commandData = commandData
        m_printableViews = New ViewSet()
        m_printableSheets = New ViewSet()
        m_selectedViews = New ViewSet()

        GetAllPrintableViews()
    End Sub

    ''' <summary> 
    ''' Get all printable views and sheets 
    ''' </summary> 
    Private Sub GetAllPrintableViews()
        Dim itor As ElementIterator = m_commandData.Application.ActiveDocument.Elements
        itor.Reset()
        m_printableViews.Clear()
        m_printableSheets.Clear()

        While itor.MoveNext()
            Dim view As View = TryCast(itor.Current, View)
            If view Is Nothing OrElse Not view.CanBePrinted Then
                Continue While
            ElseIf view.ViewType = Autodesk.Revit.Enums.ViewType.DrawingSheet Then
                m_printableSheets.Insert(view)
            Else
                m_printableViews.Insert(view)
            End If
        End While
    End Sub
End Class