﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 
Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms

''' <summary> 
''' Provide a dialog which lets users choose views to export. 
''' </summary> 
Partial Public Class SelectViewsForm
    Inherits Form
    ''' <summary> 
    ''' Data class 
    ''' </summary> 
    Private m_selectViewsData As SelectViewsData

    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="selectViewsData"></param> 
    Public Sub New(ByVal selectViewsData As SelectViewsData)
        InitializeComponent()
        m_selectViewsData = selectViewsData
        InitializeControls()
    End Sub

    ''' <summary> 
    ''' Initialize values and status of controls 
    ''' </summary> 
    Private Sub InitializeControls()
        UpdateViews()
    End Sub

    ''' <summary> 
    ''' Check all items 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonCheckAll_Click(ByVal sender As Object, ByVal e As EventArgs)
        For i As Integer = 0 To checkedListBoxViews.Items.Count - 1
            checkedListBoxViews.SetItemChecked(i, True)
        Next
    End Sub

    ''' <summary> 
    ''' Un-check all items 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonCheckNone_Click(ByVal sender As Object, ByVal e As EventArgs)
        For i As Integer = 0 To checkedListBoxViews.Items.Count - 1
            checkedListBoxViews.SetItemChecked(i, False)
        Next
    End Sub

    ''' <summary> 
    ''' Whether to show the sheets 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub checkBoxSheets_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs)
        UpdateViews()
    End Sub

    ''' <summary> 
    ''' Whether to show the views (except sheets) 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub checkBoxViews_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs)
        UpdateViews()
    End Sub

    ''' <summary> 
    ''' Update the views in the checked list box 
    ''' </summary> 
    Private Sub UpdateViews()
        checkedListBoxViews.Items.Clear()
        If checkBoxViews.Checked Then
            For Each view As Autodesk.Revit.Elements.View In m_selectViewsData.PrintableViews
                checkedListBoxViews.Items.Add((view.ViewType.ToString() & ": ") + view.ViewName)
            Next
        End If

        If checkBoxSheets.Checked Then
            For Each viewSheet As Autodesk.Revit.Elements.ViewSheet In m_selectViewsData.PrintableSheets
                checkedListBoxViews.Items.Add(("Drawing Sheet: " & viewSheet.SheetNumber & " - ") + viewSheet.ViewName)
            Next
        End If
        checkedListBoxViews.Sorted = True
    End Sub

    ''' <summary> 
    ''' OK button clicked 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
        GetSelectedViews()
        Me.Close()
    End Sub

    ''' <summary> 
    ''' Transfer information back to SelectViewsData class 
    ''' </summary> 
    Private Sub GetSelectedViews()
        m_selectViewsData.Contain3DView = False

        For Each index As Integer In checkedListBoxViews.CheckedIndices
            Dim text As [String] = checkedListBoxViews.Items(index).ToString()
            Dim sheetPrefix As [String] = "Drawing Sheet: "
            If text.StartsWith(sheetPrefix) Then
                text = text.Substring(sheetPrefix.Length)
                Dim sheetNumber As [String]
                Dim sheetViewName As [String]
                sheetNumber = text.Substring(0, text.IndexOf(" - "))
                sheetViewName = text.Substring(text.IndexOf(" - ") + 3)
                For Each viewSheet As Autodesk.Revit.Elements.ViewSheet In m_selectViewsData.PrintableSheets
                    If viewSheet.SheetNumber = sheetNumber AndAlso viewSheet.ViewName = sheetViewName Then
                        m_selectViewsData.SelectedViews.Insert(viewSheet)
                        Exit For
                    End If
                Next
            Else
                Dim viewType As [String] = text.Substring(0, text.IndexOf(": "))
                Dim viewName As [String] = text.Substring(text.IndexOf(": ") + 2)
                For Each view As Autodesk.Revit.Elements.View In m_selectViewsData.PrintableViews
                    Dim vt As Autodesk.Revit.Enums.ViewType = view.ViewType
                    If viewType = vt.ToString() AndAlso viewName = view.ViewName Then
                        m_selectViewsData.SelectedViews.Insert(view)
                        If vt = Autodesk.Revit.Enums.ViewType.ThreeD Then
                            m_selectViewsData.Contain3DView = True
                        End If
                        Exit For
                    End If
                Next
            End If
        Next
    End Sub
End Class