﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Reflection
Imports System.IO

Imports Autodesk.Revit
Imports Autodesk.Revit.Elements

''' <summary> 
''' Base data class which stores the basic information for import 
''' </summary> 
Public Class ImportData
#Region "Class Memeber Variables"
    ''' <summary> 
    ''' Revit command data 
    ''' </summary> 
    Protected m_commandData As ExternalCommandData
    ''' <summary> 
    ''' Active document 
    ''' </summary> 
    Protected m_activeDoc As Document

    ''' <summary> 
    ''' Directory where to import the file 
    ''' </summary> 
    Protected m_importFolder As [String]
    ''' <summary> 
    ''' File Name or Prefix to be used 
    ''' </summary> 
    Protected m_importFileFullName As [String]

    ''' <summary> 
    ''' The format to be exported 
    ''' </summary> 
    Protected m_importFormat As ImportFormat

    ''' <summary> 
    ''' The filter which will be used in file saving dialog 
    ''' </summary> 
    Protected m_filter As [String]

    ''' <summary> 
    ''' The title of importing dialog 
    ''' </summary> 
    Protected m_title As [String]
#End Region

#Region "Class Properties"
    ''' <summary> 
    ''' Revit command data 
    ''' </summary> 
    Public ReadOnly Property CommandData() As ExternalCommandData
        Get
            Return m_commandData
        End Get
    End Property

    ''' <summary> 
    ''' File Name or Prefix to be used 
    ''' </summary> 
    Public Property ImportFileFullName() As [String]
        Get
            Return m_importFileFullName
        End Get
        Set(ByVal value As [String])
            m_importFileFullName = value
        End Set
    End Property

    ''' <summary> 
    ''' The format to be imported 
    ''' </summary> 
    Public Property ImportFormat() As ImportFormat
        Get
            Return m_importFormat
        End Get
        Set(ByVal value As ImportFormat)
            m_importFormat = value
        End Set
    End Property

    ''' <summary> 
    ''' The filter which will be used in file saving dialog 
    ''' </summary> 
    Public ReadOnly Property Filter() As [String]
        Get
            Return m_filter
        End Get
    End Property

    ''' <summary> 
    ''' Directory where to import the file 
    ''' </summary> 
    Public Property ImportFolder() As [String]
        Get
            Return m_importFolder
        End Get
        Set(ByVal value As [String])
            m_importFolder = value
        End Set
    End Property

    ''' <summary> 
    ''' The title of importing dialog 
    ''' </summary> 
    Public ReadOnly Property Title() As [String]
        Get
            Return m_title
        End Get
    End Property
#End Region

#Region "Class Member Methods"
    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="commandData">Revit command data</param> 
    ''' <param name="importFormat">Format to import</param> 
    Public Sub New(ByVal commandData As ExternalCommandData, ByVal importFormat As ImportFormat)
        m_commandData = commandData
        m_activeDoc = commandData.Application.ActiveDocument
        m_importFormat = importFormat
        m_filter = [String].Empty
        Initialize()
    End Sub

    ''' <summary> 
    ''' Initialize the variables 
    ''' </summary> 
    Private Sub Initialize()
        'The directory into which the file will be imported 
        Dim dllFilePath As [String] = Assembly.GetExecutingAssembly().Location
        m_importFolder = Path.GetDirectoryName(dllFilePath)
        m_importFileFullName = [String].Empty
    End Sub

    ''' <summary> 
    ''' Collect the parameters and import 
    ''' </summary> 
    ''' <returns></returns> 
    Public Overridable Function Import() As Boolean
        If m_importFileFullName Is Nothing Then
            Throw New NullReferenceException()
        End If

        Return True
    End Function
#End Region
End Class