﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 

Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms


''' <summary> 
''' Provide a dialog which lets user choose the operation(export or import) 
''' </summary> 
Partial Public Class MainForm
    Inherits Form
    ''' <summary> 
    ''' Data class 
    ''' </summary> 
    Private m_mainData As MainData

    ''' <summary> 
    ''' Constructor 
    ''' </summary> 
    ''' <param name="mainData"></param> 
    Public Sub New(ByVal mainData As MainData)
        m_mainData = mainData
        InitializeComponent()
        radioButtonExport.Checked = True
        comboBoxExport.Enabled = True
        comboBoxImport.Enabled = False
        'Append formats to be exported or imported 
        InitializeFormats()
    End Sub

    ''' <summary> 
    ''' Append formats to be exported or imported 
    ''' </summary> 
    Private Sub InitializeFormats()
        ' Append formats to be exported 
        comboBoxExport.Items.Add("DWG")
        'comboBoxExport.Items.Add("2D DWF")
        'comboBoxExport.Items.Add("2D DWFx")
        'comboBoxExport.Items.Add("GBXML")
        'comboBoxExport.Items.Add("DGN")
        'If m_mainData.Is3DView Then
        '    comboBoxExport.Items.Add("3D DWF")
        '    comboBoxExport.Items.Add("3D DWFx")
        '    comboBoxExport.Items.Add("FBX")
        'End If
        'comboBoxExport.Items.Add("Civil3D")
        comboBoxExport.SelectedIndex = 0

        ' Append formats to be imported 
        comboBoxImport.Items.Add("DWG")
        'If Not m_mainData.Is3DView Then
        '    comboBoxImport.Items.Add("IMAGE")
        'End If

        'If m_mainData.CommandData.Application.Product = Autodesk.Revit.Enums.ProductType.MEP Then
        '    comboBoxImport.Items.Add("GBXML")
        'End If
        'comboBoxImport.Items.Add("Inventor")

        comboBoxImport.SelectedIndex = 0
    End Sub

    ''' <summary> 
    ''' Show the export/import dialog 
    ''' </summary> 
    ''' <param name="sender"></param> 
    ''' <param name="e"></param> 
    Private Sub buttonOK_Click(ByVal sender As Object, ByVal e As EventArgs)
        Dim selectedFormat As [String] = [String].Empty
        Dim result As DialogResult = DialogResult.OK

        If radioButtonExport.Checked = True Then
            selectedFormat = comboBoxExport.SelectedItem.ToString()
            result = m_mainData.Export(selectedFormat)
        Else
            selectedFormat = comboBoxImport.SelectedItem.ToString()
            result = m_mainData.Import(selectedFormat)
        End If

        Me.DialogResult = (If(result <> DialogResult.Cancel, DialogResult.OK, DialogResult.None))
    End Sub

    Private Sub radioButtonExport_CheckedChanged(ByVal sender As Object, ByVal e As EventArgs)
        comboBoxImport.Enabled = Not radioButtonExport.Checked
        comboBoxExport.Enabled = radioButtonExport.Checked
    End Sub
End Class
