﻿' 
' (C) Copyright 2003-2009 by Autodesk, Inc. 
' 
' Permission to use, copy, modify, and distribute this software in 
' object code form for any purpose and without fee is hereby granted, 
' provided that the above copyright notice appears in all copies and 
' that both that copyright notice and the limited warranty and 
' restricted rights notice below appear in all supporting 
' documentation. 
' 
' AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
' AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF 
' MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE. AUTODESK, INC. 
' DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE 
' UNINTERRUPTED OR ERROR FREE. 
' 
' Use, duplication, or disclosure by the U.S. Government is subject to 
' restrictions set forth in FAR 52.227-19 (Commercial Computer 
' Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
' (Rights in Technical Data and Computer Software), as applicable. 
' 


Imports System
Imports System.Collections.Generic
Imports System.Text
Imports Autodesk.Revit.Parameters
Imports Autodesk.Revit.Enums
Imports Autodesk.Revit
Imports System.Configuration
Imports System.Reflection

''' <summary> 
''' Provides static functions to convert unit 
''' </summary> 
Module Unit

#Region "Methods"
    ''' <summary> 
    ''' Convert the value get from RevitAPI to the value indicated by DisplayUnitType 
    ''' </summary> 
    ''' <param name="toType">DisplayUnitType indicates unit of target value</param> 
    ''' <param name="value">value get from RevitAPI</param> 
    ''' <returns>Target value</returns> 
    Public Function CovertFromAPI(ByVal toType As Autodesk.Revit.Enums.DisplayUnitType, ByVal value As Double) As Double
        Return value * ImperialDutRatio(toType)
    End Function

    ''' <summary> 
    ''' Convert a value indicated by DisplayUnitType to the value used by RevitAPI 
    ''' </summary> 
    ''' <param name="value">Value to be converted</param> 
    ''' <param name="from">DisplayUnitType indicates the unit of the value to be converted</param> 
    ''' <returns>Target value</returns> 
    Public Function CovertToAPI(ByVal value As Double, ByVal from As Autodesk.Revit.Enums.DisplayUnitType) As Double
        Return value / ImperialDutRatio(from)
    End Function

    ''' <summary> 
    ''' Get ratio between value in RevitAPI and value to display indicated by DisplayUnitType 
    ''' </summary> 
    ''' <param name="dut">DisplayUnitType indicates display unit type</param> 
    ''' <returns>Ratio </returns> 
    Private Function ImperialDutRatio(ByVal dut As Autodesk.Revit.Enums.DisplayUnitType) As Double
        Select Case dut
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_DECIMAL_FEET
                Return 1
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_FEET_FRACTIONAL_INCHES
                Return 1
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_DECIMAL_INCHES
                Return 12
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_FRACTIONAL_INCHES
                Return 12
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_METERS
                Return 0.3048
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_CENTIMETERS
                Return 30.48
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_MILLIMETERS
                Return 304.8
            Case Autodesk.Revit.Enums.DisplayUnitType.DUT_METERS_CENTIMETERS
                Return 0.3048
            Case Else
                Return 1
        End Select
    End Function
#End Region
End Module