#region Namespaces
using System;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace testole
{
  // This could have been read-only, but then it 
  // cannot be started in zero document state:

  [Transaction( TransactionMode.Manual )]
  public class Command : IExternalCommand
  {
    public Result Execute(
      ExternalCommandData commandData,
      ref string message,
      ElementSet elements )
    {
      Autodesk.AutoCAD.Interop.AcadApplication a 
        = new Autodesk.AutoCAD.Interop.AcadApplication();

      a.Visible = true;

      Autodesk.AutoCAD.Interop.AcadDocument doc 
        = a.Documents.Application.ActiveDocument;

      double[] stpoint = new double[3];
      double[] enpoint = new double[3];
      stpoint[0] = 5;
      stpoint[1] = 5;
      stpoint[2] = 0;
      enpoint[0] = 12;
      enpoint[1] = 3;
      enpoint[2] = 0;

      doc.ModelSpace.AddLine( stpoint, enpoint );
      
      doc.SaveAs( "C:/tmp/testline.dwg" );

      a.Quit();

      return Result.Succeeded;
    }
  }
}
