﻿#Region "Imported Namespaces"
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Diagnostics
Imports System.IO
Imports System.Reflection
Imports System.Text
Imports System.Windows
Imports System.Windows.Forms
Imports Autodesk.Revit
Imports Autodesk.Revit.ApplicationServices
Imports Autodesk.Revit.Attributes
Imports Autodesk.Revit.DB
Imports Autodesk.Revit.UI
Imports Autodesk.Revit.DB.Events
Imports System.Collections
#End Region

<Transaction(TransactionMode.Manual)> _
<Regeneration(RegenerationOption.Manual)> _
<Journaling(JournalingMode.UsingCommandData)> _
<DisplayName("Application WSPR.ADN02")> _
<Description("Application WSPR.ADN02")> _
Public Class AppCommand
  Implements IExternalApplication

  ''' <summary>
  ''' Map document title to last valid view element id
  ''' </summary>
  Public Shared viewHash As Hashtable

  Public Function OnStartup( _
    ByVal application As UIControlledApplication) _
  As Result Implements IExternalApplication.OnStartup

    Try
      viewHash = New Hashtable

      AddHandler application.ViewActivated,
        AddressOf OnViewActivated

      Return Result.Succeeded

    Catch ex As Exception

      Return Result.Failed
    End Try

  End Function

  Public Function OnShutdown( _
    ByVal application As UIControlledApplication) _
  As Result Implements IExternalApplication.OnShutdown

    Return Result.Succeeded

  End Function

  Private Shared Function ViewDescription( _
    ByVal v As DB.View) As String

    Return String.Format(
      "view '{0}' in document '{1}'",
      v.Name, v.Document.Title)

  End Function

  Private Sub OnViewActivated( _
    ByVal sender As Object,
    ByVal e As UI.Events.ViewActivatedEventArgs)

    Dim docTitle As String = e.Document.Title
    Dim vPrevious As DB.View = e.PreviousActiveView
    Dim vCurrent As DB.View = e.CurrentActiveView
    If Not (vCurrent.ViewType = ViewType.SystemBrowser _
            OrElse vCurrent.ViewType = ViewType.ProjectBrowser) Then
      If viewHash.ContainsKey(docTitle) Then
        viewHash.Item(docTitle) = vCurrent.Id
      Else
        viewHash.Add(docTitle, vCurrent.Id)
      End If
    End If

    Dim s As String = If(
      (vPrevious Is Nothing),
      "no view at all",
      "previous " + ViewDescription(vPrevious))

    Debug.Print(
      String.Format(
        "Switching from {0} to new {1}.",
        s, ViewDescription(vCurrent)))

  End Sub

End Class
