﻿#Region "Imported Namespaces"
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Diagnostics
Imports System.Drawing
Imports System.IO
Imports System.Linq
Imports System.Reflection
Imports System.Text
Imports System.Windows
Imports System.Windows.Forms
Imports Autodesk.Revit
Imports Autodesk.Revit.Attributes
#End Region

<Transaction(TransactionMode.Manual)> _
<Regeneration(RegenerationOption.Manual)> _
<Journaling(JournalingMode.UsingCommandData)> _
Public Class CmdPlaceFamilies
  Implements UI.IExternalCommand

  Public Function Execute(ByVal commandData As UI.ExternalCommandData, ByRef message As String, ByVal elements As DB.ElementSet) As UI.Result Implements UI.IExternalCommand.Execute
    Dim app As ApplicationServices.Application = commandData.Application.Application
    Dim doc As DB.Document = commandData.Application.ActiveUIDocument.Document
    Dim docUI As UI.UIDocument = commandData.Application.ActiveUIDocument

    Try
      Dim fileNameAndPath As String = "X:\CAD\Revit\2014\Library-WSP\General\Anno-Symbols\SymGen H+S Warning.rfa"
      Dim famSymbolName As String = "SymGen H+S Warning"
      Dim familySymbol As DB.FamilySymbol = LoadFamilySymbolTransaction(doc, fileNameAndPath, famSymbolName)
      If familySymbol Is Nothing Then
        MsgBox("Can't find family symbol.")
        Return UI.Result.Failed
      End If

      ' According to the help for 
      ' PromptForFamilyInstancePlacement:
      ' "Users are not permitted to change the active 
      ' view during this placement operation (the 
      ' operation will be completed)."
      ' Here's the fix, which only needs to work for 2014.
      ' (With previous versions, the ribbon items are 
      ' greyed out if the project browser is active.)

      Dim actView As DB.View = doc.ActiveView

      If actView.ViewType = DB.ViewType.SystemBrowser _
        OrElse actView.ViewType = DB.ViewType.ProjectBrowser Then

        ' Get stored view id.

        If AppCommand.viewHash.ContainsKey(doc.Title) Then

          Dim prevValidViewId As DB.ElementId _
            = AppCommand.viewHash.Item(doc.Title)

          Dim elem As DB.Element = doc.GetElement(
            prevValidViewId)

          If elem IsNot Nothing Then
            Dim view As DB.View = TryCast(elem, DB.View)
            If view IsNot Nothing Then

              ' TODO: Check that view is valid for the 
              ' placement of this type of family symbol, 
              ' otherwise get another view.
              ' (Likely to be the case, as the user 
              ' will normally click a ribbon item as 
              ' part of the context of what they're doing.)

              docUI.ActiveView = view

            End If
          End If

        End If
      End If

      docUI.PromptForFamilyInstancePlacement(
        familySymbol)

      'MsgBox("Done")
      Return UI.Result.Succeeded
    Catch ex As Exception
      'MsgBox(ex.Message)
      Return UI.Result.Failed
    End Try
  End Function

  Public Function LoadFamilySymbolTransaction(ByVal doc As DB.Document, ByVal fileNameAndPath As String, ByVal famSymName As String) As DB.FamilySymbol
    Dim familyObj As DB.FamilySymbol = Nothing
    Dim transaction As New DB.Transaction(doc, "Load Family")
    Try
      transaction.Start()
      Dim familyLoadOptions As New FamilyLoadOptions
      'familyLoadOptions.OnFamilyFound(True, True)
      'familyLoadOptions.OnSharedFamilyFound(
      doc.LoadFamilySymbol(fileNameAndPath, famSymName, familyLoadOptions, familyObj)
    Catch ex As Exception
    End Try
    transaction.Commit()
    Return familyObj
  End Function
End Class
