﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.ApplicationServices;

using System.Threading;
using System.Diagnostics;

namespace Roof
{
    public partial class UserForm : System.Windows.Forms.Form
    {

        Document document;



        ProgressBarForm progressBarForm = new ProgressBarForm();

        public UserForm(Document document)
        {
            InitializeComponent();
            this.document = document;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            openFileDialog1 = new OpenFileDialog();

            openFileDialog1.Title = "open xml";

            openFileDialog1.Filter = "xml document(*.xml)|*.xml";

            openFileDialog1.InitialDirectory = @"C:\Users\Administrator\Desktop";

            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {

                //打开文件对话框选择的文件


                String strName = openFileDialog1.FileName;
                textBox1.Text = strName;
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void button2_Click(object sender, EventArgs e)
        {



            string xmlAddress = textBox1.Text;


            
            XmlToWoodenBeamList beamList = new XmlToWoodenBeamList(xmlAddress, document);

            List<WoodenBeam> beams = beamList.WoodenBeamList;



            Stopwatch watcher = new Stopwatch();
            watcher.Start();

            //generate wooden beams
            Transaction transaction = new Transaction(document, "xxxx222xxxx");

            transaction.Start();
            label1.Text = "Calculating";


            progressBar1.Maximum = beams.Count();
            progressBar1.Minimum = 0;


            foreach (WoodenBeam wb in beams)
            {
                wb.CreateSweep();
                progressBar1.Increment(1);
            }                     

            //MessageBox.Show("Caculation finished, ready to generate?");
            

            Thread th = new Thread(new ThreadStart(this.ShowProgress));
            th.Start();
            this.Dispose();
  


            //initial the progressBar
            progressBarForm.progressBar1.Maximum = beams.Count();
            progressBarForm.progressBar1.Minimum = 0;



            int countNumber = 0;
            foreach (WoodenBeam wb in beams)
            {
                Sweep sw = wb.GenerateSweep();


                progressBarForm.progressBar1.Increment(1);
                countNumber ++;


            }




            transaction.Commit();

            watcher.Stop();


            string message = string.Format("Generate successfully. Used {0} seconds.", watcher.ElapsedMilliseconds / 1000);
            MessageBox.Show(message);

            this.document.SaveAs(@"C:\Users\Administrator\Desktop\Roofs.rfa");

            this.progressBarForm.Dispose();
            if (th.IsAlive == true)
            {
                th.Abort();
            }
        }


        private void ShowProgress()
        {
            this.progressBarForm.ShowDialog();
        }

        private void progressBar1_Click(object sender, EventArgs e)
        {

        }

        private void UserForm_Load(object sender, EventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void progressBar2_Click(object sender, EventArgs e)
        {

        }
    }
}
