﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.ApplicationServices;
using System.Windows.Forms;





namespace Roof
{
    public class WoodenBeam
    {
        Autodesk.Revit.DB.Document document;
        public List<XYZ> pointsCoodinate = new List<XYZ>();

        public double depth = 0;

        public Sweep sweep = null;

        XYZ norm = new XYZ();



        SketchPlane skplane;
        CurveArray paths = new CurveArray();
        SweepProfile profile;

        public WoodenBeam(List<XYZ> pointsCoodinate, double depth, Autodesk.Revit.DB.Document document)
        {

            //check if the points are in the same plane
            
            this.pointsCoodinate = pointsCoodinate;

            this.depth = depth;

            this.document = document;
            
        }





        public void CreateSweep()
        {

       
            //set profile

            this.profile = CreateSweepProfile();



            //set SketchPlane for path
            XYZ norm = (pointsCoodinate[1] - pointsCoodinate[0]).Normalize();            
            Plane plane = document.Application.Create.NewPlane(norm, pointsCoodinate[0]);
            this.skplane = document.FamilyCreate.NewSketchPlane(plane);

            //set path
            XYZ pathnorm = (pointsCoodinate[1] - pointsCoodinate[0]).CrossProduct(pointsCoodinate[2] - pointsCoodinate[0]).Normalize();
            Line path = document.Application.Create.NewLineBound(pointsCoodinate[0], pointsCoodinate[0] + depth * pathnorm);

            this.paths.Append(path);

  

        }

        public Sweep GenerateSweep()
        {
            if (null != this.profile)
            {
                sweep = document.FamilyCreate.NewSweep(true, paths, skplane, profile, 0, ProfilePlaneLocation.Start);
            }
            else
            {
                MessageBox.Show("Some points are not in the same plane");
            }


            return sweep;
        }




        private SweepProfile CreateSweepProfile()

        {

            List<XYZ> newpointsCoodinate = SweepOrdinationRevise(pointsCoodinate);

            List<Line> profileLineList = new List<Line>();

            CurveArray curArray = new CurveArray();

            CurveArrArray curArrArray = new CurveArrArray();


            for (int i = 0; i < (pointsCoodinate.Count()-1); i++)
            {
                
                Line line = document.Application.Create.NewLineBound(newpointsCoodinate[i], newpointsCoodinate[i+1]);
                profileLineList.Add(line);
            }
            Line endLine = document.Application.Create.NewLineBound(newpointsCoodinate[(newpointsCoodinate.Count()-1)],newpointsCoodinate[0]);
            profileLineList.Add(endLine);

            foreach (Line l in profileLineList)
            {
                curArray.Append(l);
            }

            curArrArray.Append(curArray);



            try
            {
                Plane plane = document.Application.Create.NewPlane(curArray);
            }

            catch (Exception e)
            {
                MessageBox.Show(e+"Some points are not in the same plane");
                return null;
            }

            SweepProfile result = document.Application.Create.NewCurveLoopsProfile(curArrArray);
            return result;





        }



        private List<XYZ> SweepOrdinationRevise(List<XYZ> originXYZ)
        {
            List<XYZ> revisedXYZ = new List<XYZ>();
            //coded by Hu Zhao ETHZ 
            //以originXYZ的第一个点(originXYZ[0].X,originXYZ[0].Y,originXYZ[0].Z)为新原点
            //以originXYZ所在的平面的过第一点的法线为Z轴，以第一点到第二点的向量方向为Y轴，
            double x0 = originXYZ[0].X;
            double y0 = originXYZ[0].Y;
            double z0 = originXYZ[0].Z;


            XYZ newCoodinateOriginY = (originXYZ[1] - originXYZ[0]).Normalize();
            XYZ newCoodinateOriginZ = (newCoodinateOriginY.CrossProduct(originXYZ[2] - originXYZ[0])).Normalize();
            XYZ newCoodinateOriginX = (newCoodinateOriginY.CrossProduct(newCoodinateOriginZ)).Normalize();

            double newX;
            double newY;
            double newZ;

            foreach (XYZ pt in originXYZ)
            {
                newX = (pt.X - x0) * newCoodinateOriginX.X + (pt.Y - y0) * newCoodinateOriginX.Y + (pt.Z - z0) * newCoodinateOriginX.Z;

                newY = (pt.X - x0) * newCoodinateOriginY.X + (pt.Y - y0) * newCoodinateOriginY.Y + (pt.Z - z0) * newCoodinateOriginY.Z;

                newZ = (pt.X - x0) * newCoodinateOriginZ.X + (pt.Y - y0) * newCoodinateOriginZ.Y + (pt.Z - z0) * newCoodinateOriginZ.Z;

                revisedXYZ.Add(new XYZ(newX, newY, newZ));

            }

            return revisedXYZ;
        }

     

    }
}
