﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.ApplicationServices;
using System.Windows.Forms;



namespace Roof
{
    class XmlToWoodenBeamList
    {
        public List<WoodenBeam> WoodenBeamList = new List<WoodenBeam>();
        public string xmlAddress;
        Document document;
        public XmlToWoodenBeamList(string  xmlAddress, Document document)
        {

            this.xmlAddress = xmlAddress;


            this.document = document;
            LoadXml();

        }



        //Load points information of XML file to WoodenBeamList 
        private void LoadXml()
        {
            




            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(xmlAddress);



            XmlNodeList beams = xmlDoc.SelectNodes("//Beam");
            



            foreach (XmlElement beam in beams)
            {
                List<XYZ> pointsCoodinate = new List<XYZ>();

                XmlNodeList beamChilds = beam.ChildNodes;
                
                double depth = 0;

                int field = 0;
                int section = 0;
                    
                      
                XmlNode depthNode = beam.SelectSingleNode("//Depth[@d]");

                XmlNode fieldNode = beam.SelectSingleNode("//Field[@f]");

                XmlNode sectionNode = beam.SelectSingleNode("//Section[@s]");


                depth = UnitSet.MToFeet(double.Parse(depthNode.Attributes.GetNamedItem("d").Value));
                field = int.Parse(fieldNode.Attributes.GetNamedItem("f").Value);
                section = int.Parse(sectionNode.Attributes.GetNamedItem("s").Value);

                foreach (XmlElement point in beamChilds)
                {

                    if(point.HasAttribute("x"))
                    {
                    double x = UnitSet.MToFeet(double.Parse(point.Attributes.GetNamedItem("x").Value));
                    double y = UnitSet.MToFeet(double.Parse(point.Attributes.GetNamedItem("y").Value));
                    double z = UnitSet.MToFeet(double.Parse(point.Attributes.GetNamedItem("z").Value));
                    pointsCoodinate.Add(new XYZ(x,y,z));
                    }
                    
                }
  
                
                WoodenBeam wb = new WoodenBeam(pointsCoodinate, depth, document);

                WoodenBeamList.Add(wb);

            }



        }


    }
}
