﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpatialAnalysis.ExternalConnection;

namespace SpatialAnalysis.Geometry
{
    public class Barrier
    {

        public UV[] BoundaryPoints { get; set; }
        public bool AscendingOrder { get; set; }
        public int Length
        {
            get { return this.BoundaryPoints.Length; }
        }
        public bool IsHole { get; set; }
        public Barrier(UV[] points)
        {
            this.AscendingOrder = true;
            this.BoundaryPoints = points;
        }
        public int PreviousIndex(int pointIndex)
        {
            int pre;
            if (this.AscendingOrder)
            {
                pre = (pointIndex == 0) ? this.BoundaryPoints.Length - 1 : pointIndex - 1;
            }
            else
            {
                pre = (pointIndex == this.BoundaryPoints.Length - 1) ? 0 : pointIndex + 1;
            }
            return pre;
        }
        public int NextIndex(int pointIndex)
        {
            int next;
            if (this.AscendingOrder)
            {
                next = (pointIndex == this.BoundaryPoints.Length - 1) ? 0 : pointIndex + 1;
            }
            else
            {
                next = (pointIndex == 0) ? this.BoundaryPoints.Length - 1 : pointIndex - 1;
            }
            return next;
        }
        public UV PointAt(int index)
        {
            return this.BoundaryPoints[index];
        }
        public void Visualize(IVisualize visualizer, double evevation)
        {
            visualizer.VisualizeBoundary(this.BoundaryPoints, evevation);
        }
        public double GetArea()
        {
            double area = 0;
            for (int i = 1; i < this.Length - 1; i++)
            {
                var a = this.PointAt(i) - this.PointAt(0);
                var b = this.PointAt(this.NextIndex(i)) - this.PointAt(0);
                area += a.CrossProductValue(b);
            }
            return .5 * Math.Abs(area);
        }
        public double GetPerimeter()
        {
            double perimeter = 0;
            for (int i = 0; i < this.Length; i++)
            {
                perimeter += this.PointAt(i).DistanceTo(this.PointAt(this.NextIndex(i)));
            }
            return perimeter;
        }

        public static void VisualizeBarriers(IVisualize visualizer, Barrier[] barriers, double height = 0)
        {
            foreach (Barrier item in barriers)
            {
                visualizer.VisualizeBoundary(item.BoundaryPoints, height);
            }
        }
    }
}
