﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
//Revit NameSpaces
using Autodesk.Revit.Attributes;
using Autodesk.Revit;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.UI.Selection;
using Autodesk.Revit.DB.Architecture;


namespace SpatialAnalysis.ExternalConnection
{
    public class CurveDrawingWarningSwallower : IFailuresPreprocessor
    {
        public FailureProcessingResult PreprocessFailures(FailuresAccessor a)
        {
            // inside event handler, get all warnings
            IList<FailureMessageAccessor> failures = a.GetFailureMessages();
            foreach (FailureMessageAccessor f in failures)
            {
                a.DeleteAllWarnings();
            }
            return FailureProcessingResult.Continue;
        }
    }
}