﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
//Revit NameSpaces
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
using System.Windows;
using SpatialAnalysis;
using SpatialAnalysis.Geometry;
using PickPointTest;

namespace SpatialAnalysis.ExternalConnection
{
    [Transaction(TransactionMode.Manual)]
    [Regeneration(RegenerationOption.Manual)]
    [Journaling(JournalingMode.NoCommandData)]
    class API_PickPoint_Test : IExternalCommand
    {
        public static Document doc;
        public Autodesk.Revit.UI.Result Execute(ExternalCommandData commandData, ref string message, Autodesk.Revit.DB.ElementSet elements)
        {
            doc = commandData.Application.ActiveUIDocument.Document;
            UIDocument uidoc = new UIDocument(doc);
            try
            {
                Window1 test = new Window1();
                test.ShowDialog();
                test = null;

            }
            catch (Exception er)
            {
                #region preparing the error message
                StackTrace st = new StackTrace(er, true);
                StackFrame frame = st.GetFrame(0);
                string fileName = frame.GetFileName();
                string methodName = frame.GetMethod().Name;
                int line = frame.GetFileLineNumber();
                message = er.Message + "\n" + fileName + "\nMethod Name: " + methodName + "\n" + "Line Number: " + line.ToString();
                #endregion
                return Autodesk.Revit.UI.Result.Failed;
            }
            return Autodesk.Revit.UI.Result.Succeeded;
        }


    }

    public class RevitVisualizer : IVisualize
    {
        [STAThread]
        public void VisualizeBoundary(SpatialAnalysis.Geometry.UV[] points, double elevation)
        {
            using (Transaction t = new Transaction(API_PickPoint_Test.doc, "Draw Boundary"))
            {
                t.Start();
                FailureHandlingOptions failOpt = t.GetFailureHandlingOptions();
                failOpt.SetFailuresPreprocessor(new CurveDrawingWarningSwallower());
                t.SetFailureHandlingOptions(failOpt);
                Plane p = API_PickPoint_Test.doc.Application.Create.NewPlane(XYZ.BasisZ, new XYZ(0, 0, elevation));
                SketchPlane skp = SketchPlane.Create(API_PickPoint_Test.doc, p);
                for (int i = 0; i < points.Length; i++)
                {
                    try
                    {
                        XYZ p1 = new XYZ(points[i].U, points[i].V, elevation);
                        int j = (i == points.Length - 1) ? 0 : i + 1;
                        XYZ p2 = new XYZ(points[j].U, points[j].V, elevation);
                        Line l = Line.CreateBound(p1, p2);
                        API_PickPoint_Test.doc.Create.NewModelCurve(l, skp);
                    }
                    catch (Exception e)
                    { MessageBox.Show(e.Message); }
                }
                t.Commit();
            }
        }
        [STAThread]
        public void VisualizeLine(UVLine line, double elevation)
        {
            using (Transaction t = new Transaction(API_PickPoint_Test.doc, "Draw Barriers"))
            {
                t.Start();
                FailureHandlingOptions failOpt = t.GetFailureHandlingOptions();
                failOpt.SetFailuresPreprocessor(new CurveDrawingWarningSwallower());
                t.SetFailureHandlingOptions(failOpt);
                Plane p = API_PickPoint_Test.doc.Application.Create.NewPlane(XYZ.BasisZ, new XYZ(0, 0, elevation));
                SketchPlane skp = SketchPlane.Create(API_PickPoint_Test.doc, p);
                try
                {
                    XYZ p1 = new XYZ(line.Start.U, line.Start.V, elevation);
                    XYZ p2 = new XYZ(line.End.U, line.End.V, elevation);
                    Line l = Line.CreateBound(p1, p2);
                    API_PickPoint_Test.doc.Create.NewModelCurve(l, skp);
                }
                catch (Exception e)
                { MessageBox.Show(e.Message); }

                t.Commit();
            }
        }
        [STAThread]
        public void VisualizePoint(SpatialAnalysis.Geometry.UV pnt, double size, double elevation)
        {
            XYZ p1 = new XYZ(pnt.U - size / 2, pnt.V - size / 2, elevation);
            XYZ p2 = new XYZ(pnt.U + size / 2, pnt.V + size / 2, elevation);
            XYZ q1 = new XYZ(pnt.U + size / 2, pnt.V - size / 2, elevation);
            XYZ q2 = new XYZ(pnt.U - size / 2, pnt.V + size / 2, elevation);
            using (Transaction t = new Transaction(API_PickPoint_Test.doc, "Show Point"))
            {
                t.Start();
                FailureHandlingOptions failOpt = t.GetFailureHandlingOptions();
                failOpt.SetFailuresPreprocessor(new CurveDrawingWarningSwallower());
                t.SetFailureHandlingOptions(failOpt);
                Plane pln = API_PickPoint_Test.doc.Application.Create.NewPlane(XYZ.BasisZ, new XYZ(0, 0, elevation));
                SketchPlane skp = SketchPlane.Create(API_PickPoint_Test.doc, pln);
                Line l1 = Line.CreateBound(p1, p2);
                Line l2 = Line.CreateBound(q1, q2);
                API_PickPoint_Test.doc.Create.NewModelCurve(l1, skp);
                API_PickPoint_Test.doc.Create.NewModelCurve(l2, skp);
                t.Commit();
            }
            p1 = null; p2 = null; q1 = null; q2 = null;
        }
        [STAThread]
        public void VisualizeLines(ICollection<UVLine> lines, double elevation)
        {
            using (Transaction t = new Transaction(API_PickPoint_Test.doc, "Draw lines"))
            {
                t.Start();
                FailureHandlingOptions failOpt = t.GetFailureHandlingOptions();
                failOpt.SetFailuresPreprocessor(new CurveDrawingWarningSwallower());
                t.SetFailureHandlingOptions(failOpt);
                Plane p = API_PickPoint_Test.doc.Application.Create.NewPlane(XYZ.BasisZ, new XYZ(0, 0, elevation));
                SketchPlane skp = SketchPlane.Create(API_PickPoint_Test.doc, p);
                foreach (UVLine item in lines)
                {
                    try
                    {
                        XYZ p1 = new XYZ(item.Start.U, item.Start.V, elevation);
                        XYZ p2 = new XYZ(item.End.U, item.End.V, elevation);
                        Line l = Line.CreateBound(p1, p2);
                        API_PickPoint_Test.doc.Create.NewModelCurve(l, skp);
                    }
                    catch (Exception e)
                    { MessageBox.Show(e.Message); }
                }
                t.Commit();
            }
        }
        [STAThread]
        public SpatialAnalysis.Geometry.UV PickPoint(string message)
        {
            UIDocument uidoc = new Autodesk.Revit.UI.UIDocument(API_PickPoint_Test.doc);
            XYZ xyz = uidoc.Selection.PickPoint(message);
            return new SpatialAnalysis.Geometry.UV(xyz.X, xyz.Y);
        }
    }
    

}