﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Text;
using System.Windows.Media;
using SpatialAnalysis.Geometry;

namespace PickPointTest
{
    class VisualHost : FrameworkElement
    {
        private Brush _brush { get; set; }
        private double _thickness { get; set; }
        private VisualCollection _children;
        public VisualHost()
        {
            this._children = new VisualCollection(this);
            this._brush = Brushes.DarkRed;
            this._thickness = 1;
        }
        // Provide a required override for the VisualChildrenCount property. 
        protected override int VisualChildrenCount
        {
            get { return _children.Count; }
        }
        // Provide a required override for the GetVisualChild method. 
        protected override Visual GetVisualChild(int index)
        {
            if (index < 0 || index >= _children.Count)
            {
                throw new ArgumentOutOfRangeException();
            }

            return _children[index];
        }

        public void Draw(UV center, Barrier polygon, Brush fillBrush)
        {
            StreamGeometry sg = new StreamGeometry();
            using (StreamGeometryContext sgc = sg.Open())
            {
                sgc.BeginFigure(this.toPoint(polygon.PointAt(0)), true, true);
                for (int i = 1; i < polygon.Length; i++)
                {
                    sgc.LineTo(this.toPoint(polygon.PointAt(i)), true, true);
                }
            }
            if (sg.CanFreeze) 
                sg.Freeze();
            LineGeometry lg = new LineGeometry(
                new Point(center.U - this._thickness / 2, center.V), 
                new Point(center.U + this._thickness / 2, center.V));
            if (lg.CanFreeze)
                lg.Freeze();
            DrawingVisual dv = new DrawingVisual();
            Brush _fillBrush = fillBrush.Clone();
            _fillBrush.Opacity = .3;
            Pen pen = new Pen(this._brush, this._thickness);
            using (var dvc = dv.RenderOpen())
            {
                dvc.DrawGeometry(_fillBrush, pen, sg);
                dvc.DrawGeometry(null, pen, lg);
            }
            if (dv.Drawing.CanFreeze) 
                dv.Drawing.Freeze();
            this._children.Add(dv);
        }

        private Point toPoint(UV uv)
        {
            return new Point(uv.U, uv.V);
        }

    }
}
