﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using SpatialAnalysis.Geometry;
using SpatialAnalysis.ExternalConnection;


namespace PickPointTest
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>
    public partial class Window1 : Window
    {
        private Transform _trans { get; set; }
        private Transform _transInverse { get; set; }
        private Random _randomizer = new Random(DateTime.Now.Millisecond);
        private RevitVisualizer visualizer = new RevitVisualizer();

        public Window1()
        {
            InitializeComponent();
            this.Loaded += loadTransformations;
        }

        void loadTransformations(object sender, RoutedEventArgs e)
        {
            #region Transformation
            Matrix make = Matrix.Identity;
            //scaling the drawing
            make.Scale(1, -1);
            //moving center to the center of the scene
            make.Translate(this.Scene.RenderSize.Width / 2, this.Scene.RenderSize.Height / 2);
            this._trans = new MatrixTransform(make);
            Matrix invert = make;
            invert.Invert();
            this._transInverse = new MatrixTransform(invert);
            #endregion
            this.WPFScene.RenderTransform = this._trans;
        }

        private void APIMethod_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show("Thread ID before hiding: " + System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());
            #region WPF Hiding Methods
            //this.Visibility = System.Windows.Visibility.Hidden;
            this.Hide();
            #endregion
            UV center = visualizer.PickPoint("Pick a point");
            #region WPF Unhiding: First Location Alternative
            //this.Visibility = System.Windows.Visibility.Visible;
            //this.ShowDialog();
            //this.Show();
            //MessageBox.Show("Thread ID after unhiding: " + System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());
            #endregion

            this.report.Text = "Center coordinates: " + center.ToString();
            var polygon = this.fakeIsovist(center);
            try
            {
                center.ShowPoint(this.visualizer, 2d);
                polygon.Visualize(this.visualizer, 0);
            }
            catch (Exception error1)
            {
                MessageBox.Show("Exception rasied when drawing in Revit using PickPoint API method:\n" + 
                    error1.Message);
            }
            try
            {
                this.WPFScene.Draw(center, polygon,this.APIMethod.Background);
            }
            catch (Exception error2)
            {
                MessageBox.Show("Exception rasied when drawing in WPF using PickPoint API method:\n" +
                    error2.Message);
            }
            #region WPF Unhiding: Second Location Alternative
            //this.Visibility = System.Windows.Visibility.Visible;
            this.ShowDialog();
            //this.Show();
            MessageBox.Show("Thread ID after unhiding: " + System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());
            #endregion
        }

        private void WPFMethod_Click(object sender, RoutedEventArgs e)
        {
            this.WPFMethod.IsEnabled = false;
            this.APIMethod.IsEnabled = false;
            this.message.Visibility = System.Windows.Visibility.Visible;
            this.Scene.MouseLeftButtonDown += new MouseButtonEventHandler(Scene_MouseLeftButtonDown);
        }

        void Scene_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            this.WPFMethod.IsEnabled = true;
            this.APIMethod.IsEnabled = true;
            this.message.Visibility = System.Windows.Visibility.Collapsed;
            this.Scene.MouseLeftButtonDown -= Scene_MouseLeftButtonDown;
            var pointOnScreen = Mouse.GetPosition(this.Scene);
            var point = this._transInverse.Transform(pointOnScreen);
            UV center = new UV(point.X, point.Y);
            this.report.Text = "Center coordinates: " + center.ToString();
            var polygon = this.fakeIsovist(center);
            try
            {
                center.ShowPoint(this.visualizer, 2d);
                polygon.Visualize(this.visualizer, 0);
            }
            catch (Exception error1)
            {
                MessageBox.Show("Exception rasied when drawing in Revit using WPF PickPoint method:\n" +
                    error1.Message);
            }
            try
            {
                this.WPFScene.Draw(center, polygon, this.WPFMethod.Background);
            }
            catch (Exception error2)
            {
                MessageBox.Show("Exception rasied when drawing in WPF using WPF PickPoint method:\n" +
                    error2.Message);
            }
        }

        private Barrier fakeIsovist(UV vantagePoint)
        {
            double r1 = 10, r2 = 60;
            UV[] pnts = new UV[this._randomizer.Next(10, 40)];
            double angle = 0;
            double intercept = (double)(2 * Math.PI) / pnts.Length;
            for (int i = 0; i < pnts.Length; i++)
            {
                UV uv = new UV(Math.Cos(angle), Math.Sin(angle));
                pnts[i] = vantagePoint + uv * (r1 + (r2 - r1) * this._randomizer.NextDouble());
                angle += intercept;
            }
            return new Barrier(pnts);
        }
    }
}
