
#include "AddinTest.h"

using namespace AddinTests;
using namespace Autodesk::Revit::UI::Selection;

Result TransformTest::Execute(ExternalCommandData^ commandData, System::String^% msg, ElementSet^ elements)
{
  // some common data needed
  m_commandData     = commandData;
  m_uiApplication   = commandData->Application;
  m_uiDocument      = m_uiApplication->ActiveUIDocument;
  m_application     = m_uiApplication->Application;
  m_document        = commandData->Application->ActiveUIDocument->Document;

  List<Element^> ^linkedDwg;
  linkedDwg = dwgLinkInstances(m_document);  // Linked dwg projects

  // Here we loop every linked dwg project
  for each(Element^ linkedElem in linkedDwg)
  {
    checkLinkedDwg(linkedElem);
  }

  return Result::Succeeded;
}

//-------------------------------------------------------------------------------------

void TransformTest::checkLinkedDwg(Element^ linked)
{
  Instance ^iLinked = safe_cast<Instance^>(linked);
  Transform ^transform = iLinked->GetTransform();

  Options options;
  options.View = m_document->ActiveView;
  GeometryElement ^gElem = iLinked->Geometry::get(%options);

  // No transformation
  Mesh ^mesh = fetchSomeMesh(gElem);

  XYZ ^vertex = mesh->Vertices[0];
  //Windows::Forms::MessageBox::Show(vertex->ToString(), %String(L"Point without Transformation"));
  Debug::Print( "Point without Transformation: " + vertex->ToString() );

  // With transformation
  mesh = fetchSomeMesh(gElem, transform);

  vertex = mesh->Vertices[0];
  //Windows::Forms::MessageBox::Show(vertex->ToString(), %String(L"Point when Transformed"));
  Debug::Print( "Point when Transformed: " + vertex->ToString() );

  vertex = transform->Inverse->OfPoint(vertex);
  //Windows::Forms::MessageBox::Show(vertex->ToString(), %String(L"Point when Transformed + inverse"));
  Debug::Print( "Point when Transformed + inverse: " + vertex->ToString() );
}

//-------------------------------------------------------------------------------------

Mesh^ TransformTest::fetchSomeMesh(GeometryElement ^gElem)
{
  for each (GeometryObject ^gObject in gElem->Objects)
  {
    Mesh ^gMesh = dynamic_cast<Mesh^>(gObject);
    if (gMesh)
    {
      return gMesh;
    }
  }

  // Loop and seek for geometry instances
  for each (GeometryObject ^gObject in gElem->Objects)
  {
    GeometryInstance ^gInstance = dynamic_cast<GeometryInstance^>(gObject);
    if (gInstance)
    {
      // If it's GeometryInstance, go recursive
      return fetchSomeMesh(gInstance->SymbolGeometry);
    }
  }

  return nullptr;
}

//-------------------------------------------------------------------------------------

Mesh^ TransformTest::fetchSomeMesh(GeometryElement ^gElem, Transform ^transform)
{
  // Apply transformation and seek for Meshes
  GeometryElement ^transformed = gElem->GetTransformed(transform);

  for each (GeometryObject ^gObject in transformed->Objects)
  {
    Mesh ^gMesh = dynamic_cast<Mesh^>(gObject);
    if (gMesh)
    {
      return gMesh;
    }
  }

  // Loop and seek for geometry instances
  for each (GeometryObject ^gObject in gElem->Objects)
  {
    GeometryInstance ^gInstance = dynamic_cast<GeometryInstance^>(gObject);
    if (gInstance)
    {
      // If it's GeometryInstance, combine transformations and go recursive
      Transform ^combinedTransform = gInstance->Transform->Multiply(transform);
      return fetchSomeMesh(gInstance->SymbolGeometry, combinedTransform);
    }
  }

  return nullptr;
}

//-------------------------------------------------------------------------------------

List<Element^>^ TransformTest::dwgLinkInstances(Document^ document)
{
  ElementClassFilter classFilter(Instance::typeid);

  FilteredElementCollector elementCollector(document);
  elementCollector.WherePasses(%classFilter);


  //List<ElementId^>^ externals = safe_cast<List<ElementId^>^>(ExternalFileUtils::GetAllExternalFileReferences(document));


  List<Element^>^ instances = gcnew List<Element^>();

  for each (Element ^elem in %elementCollector)
  {    
    if(elem->ObjectType->Name->EndsWith(L".dwg", StringComparison::OrdinalIgnoreCase))
      instances->Add(elem);
  }

  return instances;
}
