#pragma once

namespace AddinTests
{
  //using namespace Autodesk::Revit;
  using namespace Autodesk::Revit::DB;
  using namespace Autodesk::Revit::UI;
  using namespace Autodesk::Revit::ApplicationServices;
  using namespace System;
  using namespace System::Diagnostics;
  //using namespace System::Text;
  using namespace System::Collections::Generic;

  [Autodesk::Revit::Attributes::TransactionAttribute(Autodesk::Revit::Attributes::TransactionMode::Manual)]
  [Autodesk::Revit::Attributes::RegenerationAttribute(Autodesk::Revit::Attributes::RegenerationOption::Manual)]
  
  public ref class TransformTest : IExternalCommand
  {
    public:
    virtual Result Execute(ExternalCommandData^ commandData, System::String^% msg, ElementSet^ elements);

    protected:
      void checkLinkedDwg(Element^ linked);

      List<Element^>^ dwgLinkInstances(Document^ document);

      Mesh^ fetchSomeMesh(GeometryElement ^gElem);
      Mesh^ fetchSomeMesh(GeometryElement ^gElem, Transform ^transform);

    private:
      ExternalCommandData  ^m_commandData;
      UIApplication        ^m_uiApplication;
      UIDocument           ^m_uiDocument;
      Application          ^m_application;
      Document             ^m_document;
  };
}

